package org.tuzhao.library.adapter;

import android.content.Context;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

/**
 * @author tuzhao
 *         Created by tuzhao on 16-3-24.
 */
public class ViewHolderHelper {

	private final SparseArray<View> views;
	private View mConvertView;

	public ViewHolderHelper(Context context, int layoutId, View convertView, ViewGroup parent) {
		this.views = new SparseArray<>();
		mConvertView = LayoutInflater.from(context).inflate(layoutId, parent, false);
		mConvertView.setTag(this);
	}

	public static ViewHolderHelper init(Context context, int layoutId, View convertView, ViewGroup parent) {
		if (convertView == null) {
			return new ViewHolderHelper(context, layoutId, null, parent);
		}
		return (ViewHolderHelper) convertView.getTag();
	}

	@SuppressWarnings("unchecked")
	public <T extends View> T get(int viewId) {
		View view = views.get(viewId);
		if (view == null) {
			view = mConvertView.findViewById(viewId);
			views.put(viewId, view);
		}
		return (T) view;
	}

	public View getConvertView() {
		return mConvertView;
	}


}
