/*******************************************************************************
 * Copyright 2011, 2012 Chris Banes.
 * <p/>
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * <p/>
 * http://www.apache.org/licenses/LICENSE-2.0
 * <p/>
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *******************************************************************************/
package org.tuzhao.library.debug;

/**
 * interface for a logger class to replace the static calls to {@link android.util.Log}
 */
public interface Logger {
	/**
	 * Send a {@link android.util.Log#VERBOSE} log message.
	 * @param tag Used to identify the source of a log message.  It usually identifies
	 *            the class or activity where the log call occurs.
	 * @param msg The message you would like logged.
	 * @return int
	 */
	int v(String tag, String msg);

	/**
	 * Send a {@link android.util.Log#VERBOSE} log message and log the exception.
	 * @param tag Used to identify the source of a log message.  It usually identifies
	 *            the class or activity where the log call occurs.
	 * @param msg The message you would like logged.
	 * @param tr  An exception to log
	 * @return int
	 */
	int v(String tag, String msg, Throwable tr);

	int vt(String tag, String msg);

	/**
	 * Send a {@link android.util.Log#DEBUG} log message.
	 * @param tag Used to identify the source of a log message.  It usually identifies
	 *            the class or activity where the log call occurs.
	 * @param msg The message you would like logged.
	 * @return int
	 */
	int d(String tag, String msg);

	/**
	 * Send a {@link android.util.Log#DEBUG} log message and log the exception.
	 * @param tag Used to identify the source of a log message.  It usually identifies
	 *            the class or activity where the log call occurs.
	 * @param msg The message you would like logged.
	 * @param tr  An exception to log
	 * @return int
	 */
	int d(String tag, String msg, Throwable tr);

	int dt(String tag, String msg);

	/**
	 * Send an {@link android.util.Log#INFO} log message.
	 * @param tag Used to identify the source of a log message.  It usually identifies
	 *            the class or activity where the log call occurs.
	 * @param msg The message you would like logged.
	 * @return int
	 */
	int i(String tag, String msg);

	/**
	 * Send a {@link android.util.Log#INFO} log message and log the exception.
	 * @param tag Used to identify the source of a log message.  It usually identifies
	 *            the class or activity where the log call occurs.
	 * @param msg The message you would like logged.
	 * @param tr  An exception to log
	 * @return int
	 */
	int i(String tag, String msg, Throwable tr);

	int it(String tag, Object msg);

	/**
	 * Send a {@link android.util.Log#WARN} log message.
	 * @param tag Used to identify the source of a log message.  It usually identifies
	 *            the class or activity where the log call occurs.
	 * @param msg The message you would like logged.
	 * @return int
	 */
	int w(String tag, String msg);

	/**
	 * Send a {@link android.util.Log#WARN} log message and log the exception.
	 * @param tag Used to identify the source of a log message.  It usually identifies
	 *            the class or activity where the log call occurs.
	 * @param msg The message you would like logged.
	 * @param tr  An exception to log
	 * @return int
	 */
	int w(String tag, String msg, Throwable tr);

	int wt(String tag, String msg);

	/**
	 * Send an {@link android.util.Log#ERROR} log message.
	 * @param tag Used to identify the source of a log message.  It usually identifies
	 *            the class or activity where the log call occurs.
	 * @param msg The message you would like logged.
	 * @return int
	 */
	int e(String tag, String msg);

	int e(String tag, Exception e);

	/**
	 * Send a {@link android.util.Log#ERROR} log message and log the exception.
	 * @param tag Used to identify the source of a log message.  It usually identifies
	 *            the class or activity where the log call occurs.
	 * @param msg The message you would like logged.
	 * @param tr  An exception to log
	 * @return int
	 */
	int e(String tag, String msg, Throwable tr);

	int et(String tag, String msg);
}
