package org.tuzhao.library.debug.mail;

import java.util.Properties;

public class MailInfo {
	/**
	 * 服务器的IP
	 */
	public String mailServerHost;
	/**
	 * 服务器的端口
	 */
	public String mailServerPort = "25";
	/**
	 * 邮件发送者的地址
	 */
	public String fromAddress;
	/**
	 * 邮件接收者的地址
	 */
	public String toAddress;
	/**
	 * 登陆邮件发送服务器的用户名
	 */
	public String userName;
	/**
	 * 登陆邮件发送服务器的密码
	 */
	public String password;
	/**
	 * 是否需要身份验证
	 */
	public boolean validate = true;
	/**
	 * 邮件主题
	 */
	public String subject;
	/**
	 * 邮件的文本内容
	 */
	public String content;
	/**
	 * 邮件附件的文件名
	 */
	public String[] attachFileNames;

	/**
	 * 获得邮件会话属性
	 */
	public Properties getProperties() {
		Properties p = new Properties();
		p.put("mail.smtp.host", this.mailServerHost);
		p.put("mail.smtp.port", this.mailServerPort);
		p.put("mail.smtp.auth", validate ? "true" : "false");
		return p;
	}

	public MailInfo() {
	}

}