package org.tuzhao.library.debug.mail;

import org.tuzhao.library.debug.DebugUtil;
import org.tuzhao.library.debug.LogManager;

import java.util.Date;
import java.util.Properties;

import javax.activation.DataHandler;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

/**
 * 简单邮件（不带附件的邮件）发送器
 */
public class MailSender {
	/**
	 * 以文本格式发送邮件
	 * @param info 待发送的邮件的信息
	 */
	public static boolean sendTextMail(MailInfo info) {
		// 判断是否需要身份认证    
		MailAuthenticator authenticator = null;
		Properties pro = info.getProperties();
		if (info.validate) {
			// 如果需要身份认证，则创建一个密码验证器    
			authenticator = new MailAuthenticator(info.userName, info.password);
		}
		// 根据邮件会话属性和密码验证器构造一个发送邮件的session    
		Session session = Session.getInstance(pro, authenticator);
		session.setDebug(DebugUtil.getInstance().getModel());
		try {
			// 根据session创建一个邮件消息    
			Message mailMessage = new MimeMessage(session);
			// 创建邮件发送者地址    
			Address from = new InternetAddress(info.fromAddress);
			// 设置邮件消息的发送者    
			mailMessage.setFrom(from);
			// 创建邮件的接收者地址，并设置到邮件消息中    
			Address to = new InternetAddress(info.toAddress);
			mailMessage.setRecipient(Message.RecipientType.TO, to);
			// 设置邮件消息的主题    
			mailMessage.setSubject(info.subject);
			// 设置邮件消息发送的时间    
			mailMessage.setSentDate(new Date());
			// 设置邮件消息的主要内容    
			String mailContent = info.content;
			mailMessage.setText(mailContent);
			// 发送邮件    
			Transport.send(mailMessage);
			return true;
		} catch (MessagingException ex) {
			LogManager.getDefaultLogger().e("sendTextMail", ex);
			return false;
		}
	}

	/**
	 * email  手机人电子邮箱
	 * subject 邮件标题
	 * body 正文内容
	 * paths  发送的附件路径集合
	 **/
	public static void sendEmail(MailInfo info, ClassLoader loader) {
		try {
			Properties props = info.getProperties();
			// 判断是否需要身份认证
			MailAuthenticator authenticator = null;
			if (info.validate) {
				// 如果需要身份认证，则创建一个密码验证器
				authenticator = new MailAuthenticator(info.userName, info.password);
			}
			Session session = Session.getInstance(props, authenticator);
			session.setDebug(DebugUtil.getInstance().getModel());

			MimeMessage msg = new MimeMessage(session);

			// 创建邮件发送者地址
			Address from = new InternetAddress(info.fromAddress);
			// 设置邮件消息的发送者
			msg.setFrom(from);
			// 创建邮件的接收者地址，并设置到邮件消息中
			Address to = new InternetAddress(info.toAddress);
			msg.setRecipient(Message.RecipientType.TO, to);
			// 设置邮件消息的主题
			msg.setSubject(info.subject, "UTF-8");
			// 设置邮件消息发送的时间
			msg.setSentDate(new Date());

			MimeMultipart multi = new MimeMultipart();   //代表整个邮件邮件

			MimeBodyPart textBodyPart = new MimeBodyPart();  //设置正文对象
			textBodyPart.setText(info.content);                  //设置正文
			multi.addBodyPart(textBodyPart);             //添加正文到邮件

			if (info.attachFileNames != null) {
				if (info.attachFileNames.length > 0) {
					for (String path : info.attachFileNames) {
						MimeBodyPart attachPart = new MimeBodyPart();
						FileDataSource source = new FileDataSource(path);
						attachPart.setDataHandler(new DataHandler(source));
						attachPart.setFileName(source.getName());
						multi.addBodyPart(attachPart);
					}
				}
			}

			msg.setContent(multi);//将整个邮件添加到message中
			msg.saveChanges();

			// 获取SMTP协议客户端对象，连接到指定SMPT服务器
			Transport transport = session.getTransport("smtp");
			transport.connect(info.mailServerHost, Integer.parseInt(info.mailServerPort), info.userName, info.password);
			it("sendEmail", "connet it success!!!!");

			// 发送邮件到SMTP服务器
			Thread.currentThread().setContextClassLoader(loader);
			Transport.send(msg);
			it("sendEmail", "send it success!!!!");

			// 关闭连接
			transport.close();

		} catch (Exception e) {
			LogManager.getDefaultLogger().e("sendTextMail", e);
		}
	}

	private static void it(String tag, Object msg) {
		LogManager.getDefaultLogger().it(tag, msg);
	}

}