package org.tuzhao.library.dialog;

import android.annotation.SuppressLint;
import android.app.Dialog;
import android.content.Context;
import android.graphics.drawable.AnimationDrawable;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;

import org.tuzhao.library.R;


/**
 * 带有文字描述
 * 自定义dialog 实现loading效果
 * @author tuzhao
 * @deprecated
 */
public class LoadingDesDialog extends Dialog {
	private static TextView desTv;
	private Context context;
	private static LoadingDesDialog customProgressDialog = null;

	public LoadingDesDialog(Context context) {
		super(context);
		this.context = context;
	}

	public LoadingDesDialog(Context context, int theme) {
		super(context, theme);
		this.context = context;
	}

	public static LoadingDesDialog createDialog(Context context, String des) {
		customProgressDialog = new LoadingDesDialog(context, R.style.CustomProgressDialog);
		@SuppressLint("InflateParams")
		View inflate = LayoutInflater.from(context).inflate(R.layout.custom_dialog_des_progress, null);
		desTv = (TextView) inflate.findViewById(R.id.loading_progress_des_tv);
		if (TextUtils.isEmpty(des)) {
			desTv.setVisibility(View.GONE);
		} else {
			desTv.setText(des);
		}
		customProgressDialog.setContentView(inflate);
		customProgressDialog.getWindow().getAttributes().gravity = Gravity.CENTER;
		customProgressDialog.setCancelable(false);
		customProgressDialog.setCanceledOnTouchOutside(false);
		return customProgressDialog;
	}

	@Override
	public void onWindowFocusChanged(boolean hasFocus) {
		if (customProgressDialog == null) {
			return;
		}
		ImageView imageView = (ImageView) customProgressDialog.findViewById(R.id.loadingImageView);

		AnimationDrawable anim = new AnimationDrawable();
		for (int i = 1; i < 5; i++) {
			//根据资源名称和目录获取R.java中对应的资源ID
			int id = context.getResources().getIdentifier("loading_f" + i, "drawable", context.getPackageName());
			//根据资源ID获取到Drawable对象
			Drawable drawable = context.getResources().getDrawable(id);
			//将此帧添加到AnimationDrawable中
			anim.addFrame(drawable, 200);
		}
		anim.setOneShot(false);
		//noinspection deprecation
		imageView.setBackgroundDrawable(anim);
		anim.start();
	}

	public void setText(String des) {
		if (customProgressDialog != null) {
			desTv.setText(des);
		}
	}


}