package org.tuzhao.library.generics;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

/**
 * @author tuzhao
 *         Created by tuzhao on 16-3-17.
 */
public class ResolveGenerics<T> implements BaseGenerics<T> {

	private Class<T>cls;

	public ResolveGenerics() {
		Type genType = getClass().getGenericSuperclass();
		Type[] params = ((ParameterizedType) genType).getActualTypeArguments();
		cls = (Class) params[0];
	}

	@Override
	public T get() {
		try {
			return cls.newInstance();
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}
}
