package org.tuzhao.library.helper;

import android.app.Activity;
import android.os.Build;
import android.support.annotation.NonNull;

import org.tuzhao.library.R;
import org.tuzhao.library.debug.LogManager;
import org.tuzhao.library.dialog.LoadOneDialog;
import org.tuzhao.library.dialog.LoadTwoDialog;

/**
 * loading dialog helper (util)<br>
 * at present only have one animation,but I will add more animation in future !
 * @author tuzhao
 */
public final class LoadingHelper {

	private static LoadingHelper instance;

	private LoadOneDialog one;
	private LoadTwoDialog two;

	private LoadingHelper() {

	}

	public static LoadingHelper getInstance() {
		if (instance == null) {
			instance = new LoadingHelper();
		}
		return instance;
	}

	/**
	 * start show loading progress dialog<br>
	 * this method only use in UI thread!
	 * @param context Activity  current interface context
	 */
	public void startProgressDialog(Activity context) {
		try {
			if (null != context) {
				if (one == null) {
					one = new LoadOneDialog(context, R.style.CustomProgressDialog);
				}
				if (!one.isShowing()) {
					one.show();
				}
			}
		} catch (Exception e) {
			ie(e);
		}
	}

	public void startProgressDesDialog(Activity context, @NonNull String des) {
		try {
			if (null != context) {
				if (two == null) {
					two = new LoadTwoDialog(context, R.style.CustomProgressDialog);
				}
				two.setText(des);
				if (!two.isShowing()) {
					two.show();
				}
			}
		} catch (Exception e) {
			ie(e);
		}
	}

	/**
	 * close current showing dialog<br>
	 * this method only use in UI thread!
	 */
	public void stopProgressDialog(Activity context) {
		try {
			if (!getActivityState(context)) {
				if (one != null) {
					if (one.isShowing()) {
						one.dismiss();
					}
					one = null;
				}
			}
		} catch (Exception e) {
			ie(e);
		}
	}

	public void stopProgressDesDialog(Activity context) {
		try {
			if (!getActivityState(context)) {
				if (two != null) {
					if (two.isShowing()) {
						two.dismiss();
					}
					two = null;
				}
			}
		} catch (Exception e) {
			ie(e);
		}
	}

	public void setText(@NonNull String des) {
		try {
			if (two != null) {
				two.setText(des);
			}
		} catch (Exception e) {
			ie(e);
		}
	}

	/**
	 * 判断当前的activity是否正常运行中
	 * @param context Activity
	 * @return true 已经执行了关闭步骤; false  正常运行中
	 */
	public boolean getActivityState(Activity context) {
		if (null != context) {
			if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN_MR1) {
				return context.isDestroyed();
			} else {
				return context.isFinishing();
			}
		}
		return true;
	}

	public void it(@NonNull String tag, @NonNull Object msg) {
		LogManager.getDefaultLogger().it(tag, msg);
	}

	public void ie(Exception e) {
		LogManager.getDefaultLogger().e(LoadingHelper.class.getSimpleName(), e);
	}


}
