package org.tuzhao.library.tools;

import android.app.Activity;
import android.content.Context;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;

import org.tuzhao.library.debug.LogManager;

/**
 * @author tuzhao
 *         Created by tuzhao on 16-1-6.
 */
public class InputManagerUtil {

	/**
	 * 隐藏activity界面的输入法
	 * @param context Activity
	 */
	@SuppressWarnings("ConstantConditions")
	public static void hideInputManagerAll(Activity context) {
		try {
			InputMethodManager inputManager = (InputMethodManager) context.getSystemService(Context.INPUT_METHOD_SERVICE);
			inputManager.hideSoftInputFromWindow(context.getCurrentFocus().getWindowToken(), InputMethodManager.HIDE_NOT_ALWAYS);
			boolean isOpen = inputManager.isActive();//isOpen若返回true，则表示输入法打开
			it("InputMethodManager", isOpen + "");
		} catch (NullPointerException e) {
			it("hideInputManagerAll cause exception!", context.getClass().getSimpleName() + " you need to deal!");
		}
	}

	/**
	 * 隐藏activity界面指定edit text的输入法
	 * @param context Activity
	 * @param et_sub  EditText
	 */
	public static void hideInputManagerOne(Activity context, EditText et_sub) {
		try {
			InputMethodManager inputManager = (InputMethodManager) context.getSystemService(Context.INPUT_METHOD_SERVICE);
			inputManager.hideSoftInputFromWindow(et_sub.getWindowToken(), InputMethodManager.HIDE_NOT_ALWAYS);
			boolean isOpen = inputManager.isActive();//isOpen若返回true，则表示输入法打开
			it("InputMethodManager", isOpen + "");
		} catch (NullPointerException e) {
			it("hideInputManagerOne cause exception!", context.getClass().getSimpleName() + " you need to deal!");
		}
	}
	
	private static void it(String tag,Object msg){
		LogManager.getDefaultLogger().it(tag, msg);
	}


}
