package org.tuzhao.library.tools;

import org.tuzhao.library.debug.LogManager;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

/**
 * 数据持久化工具类
 * @author tuzhao
 *         Created by tuzhao on 16-4-12.
 */
public class SaveDataUtil {

	public static boolean saveObj(Object saveObj, String savePath, String fileName) {
		if (saveObj == null || savePath == null || fileName == null) {
			return false;
		}

		File file = new File(savePath);
		if (!file.exists()) {
			//noinspection ResultOfMethodCallIgnored
			file.mkdirs();
		}

		FileOutputStream fo = null;
		ObjectOutputStream out = null;
		try {
			fo = new FileOutputStream(savePath + "/" + fileName);
			out = new ObjectOutputStream(fo);
			out.writeObject(saveObj);
		} catch (Exception e) {
			ie(e);
			return false;
		} finally {
			if (fo != null) {
				try {
					fo.close();
				} catch (IOException e) {
					ie(e);
				}
			}
			if (out != null) {
				try {
					out.close();
				} catch (IOException e) {
					ie(e);
				}
			}
		}
		return true;
	}

	public static <T> T getObj(Class<T> c, String savePath, String fileName) {
		if (savePath == null || fileName == null) {
			return null;
		}

		File file = new File(savePath + "/" + fileName);
		if (!file.exists()) {
			return null;
		}

		T o = null;
		FileInputStream fi = null;
		ObjectInputStream oi = null;
		try {
			fi = new FileInputStream(savePath + "/" + fileName);
			oi = new ObjectInputStream(fi);
			o = c.cast(oi.readObject());
		} catch (Exception e) {
			ie(e);
			return null;
		} finally {
			if (fi != null) {
				try {
					fi.close();
				} catch (IOException e) {
					ie(e);
				}
			}
			if (oi != null) {
				try {
					oi.close();
				} catch (IOException e) {
					ie(e);
				}
			}
		}
		return o;
	}

	private static void ie(Exception e) {
		LogManager.getDefaultLogger().e(SaveDataUtil.class.getSimpleName(), e);
	}


}
