package org.tuzhao.library.tools;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.graphics.Color;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.LinearLayout;

/**
 * @author tuzhao
 *         Created by tuzhao on 16-3-15.
 */
public class StatusBar {

	public static void setStatusBarTrans(Activity context) {
		context.getWindow().requestFeature(Window.FEATURE_NO_TITLE);
		if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
			Window window = context.getWindow();
			window.clearFlags(WindowManager.LayoutParams.FLAG_TRANSLUCENT_STATUS | WindowManager.LayoutParams.FLAG_TRANSLUCENT_NAVIGATION);
			window.getDecorView().setSystemUiVisibility(View.SYSTEM_UI_FLAG_LAYOUT_FULLSCREEN | View.SYSTEM_UI_FLAG_LAYOUT_HIDE_NAVIGATION | View.SYSTEM_UI_FLAG_LAYOUT_STABLE);
			window.addFlags(WindowManager.LayoutParams.FLAG_DRAWS_SYSTEM_BAR_BACKGROUNDS);
			window.setStatusBarColor(Color.TRANSPARENT);
			window.setNavigationBarColor(Color.BLACK);
		}
	}

	/**
	 * 设置状态栏背景状态 采用add view的方式
	 * @param context  Activity
	 * @param layoutId layoutId
	 * @param colorId1 colorId1
	 * @param colorId2 colorId2
	 * @return view
	 */
	public static View setStatusBar(Activity context, int layoutId, int colorId1, int colorId2) {
		@SuppressLint("InflateParams")
		View inflate = context.getLayoutInflater().inflate(layoutId, null);
		if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT) {
			View view = new View(context);
			ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, getStatusBarHeight1(context));
			view.setLayoutParams(layoutParams);
			view.setBackgroundResource(colorId1);
			LinearLayout linearLayout = new LinearLayout(context);
			ViewGroup.LayoutParams layoutParams2 = new ViewGroup.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT);
			linearLayout.setLayoutParams(layoutParams2);
			linearLayout.setOrientation(LinearLayout.VERTICAL);
			linearLayout.setBackgroundResource(colorId2);
			linearLayout.addView(view, 0);
			linearLayout.addView(inflate, ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT);
			Window win = context.getWindow();
			WindowManager.LayoutParams winParams = win.getAttributes();
			final int bits = WindowManager.LayoutParams.FLAG_TRANSLUCENT_STATUS;
			winParams.flags |= bits;
			win.setAttributes(winParams);
			SystemStatusManager tintManager = new SystemStatusManager(context);
			tintManager.setStatusBarTintEnabled(true);
			tintManager.setStatusBarTintResource(0);//状态栏无背景
			return linearLayout;
		} else {
			return inflate;
		}
	}

	/**
	 * 设置状态栏背景状态 采用add view的方式
	 * @param context  Activity
	 * @param inflate     inflate
	 * @param colorId1 colorId1
	 * @param colorId2 colorId2
	 * @return view
	 */
	public static View setStatusBar(Activity context, View inflate, int colorId1, int colorId2) {
		if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT) {
			View view = new View(context);
			ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, getStatusBarHeight1(context));
			view.setLayoutParams(layoutParams);
			view.setBackgroundResource(colorId1);
			LinearLayout linearLayout = new LinearLayout(context);
			ViewGroup.LayoutParams layoutParams2 = new ViewGroup.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT);
			linearLayout.setLayoutParams(layoutParams2);
			linearLayout.setOrientation(LinearLayout.VERTICAL);
			linearLayout.setBackgroundResource(colorId2);
			linearLayout.addView(view, 0);
			linearLayout.addView(inflate, ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT);
			Window win = context.getWindow();
			WindowManager.LayoutParams winParams = win.getAttributes();
			final int bits = WindowManager.LayoutParams.FLAG_TRANSLUCENT_STATUS;
			winParams.flags |= bits;
			win.setAttributes(winParams);
			SystemStatusManager tintManager = new SystemStatusManager(context);
			tintManager.setStatusBarTintEnabled(true);
			tintManager.setStatusBarTintResource(0);//状态栏无背景
			return linearLayout;
		} else {
			return inflate;
		}
	}

	/**
	 * 获取系统状态栏的高度
	 * @param context Activity
	 * @return 高度
	 */
	public static int getStatusBarHeight1(Activity context) {
		int result = 0;
		int resourceId = context.getResources().getIdentifier("status_bar_height", "dimen", "android");
		if (resourceId > 0) {
			result = context.getResources().getDimensionPixelSize(resourceId);
		}
		return result;
	}

	/**
	 * 通过反射获取系统顶部状态栏的高度
	 * @param context Activity
	 * @return 高度
	 */
	public static int getStatusHeight2(Activity context) {
		try {
			Class<?> clazz = Class.forName("com.android.internal.R$dimen");
			Object object = clazz.newInstance();
			int height = Integer.parseInt(clazz.getField("status_bar_height").get(object).toString());
			return context.getResources().getDimensionPixelSize(height);
		} catch (Exception e) {
			e.printStackTrace();
			return -1;
		}
	}

}
