package org.tuzhao.library.tools;

import android.content.Context;
import android.support.annotation.NonNull;
import android.widget.Toast;

import org.tuzhao.library.debug.LogManager;

import java.lang.String;

/**
 * @author tuzhao
 *         Created by tuzhao on 16-1-4.
 */
public class ToastUtil {

	private static Toast mToast = null;
	private static Toast mLongToast = null;

	/**
	 * 消息提示
	 * @param context Context
	 * @param msg     msg
	 */
	public static void msgBox(Context context, @NonNull String msg) {
		try {
			if (context != null) {
				Toast.makeText(context, msg, Toast.LENGTH_SHORT).show();
			}
		} catch (Exception e) {
			ie(e);
		}
	}

	/**
	 * show msg in toast
	 * @param context Context
	 * @param text    des
	 */
	public static void showMsg(Context context, @NonNull String text) {
		try {
			if (context != null) {
				if (mToast == null) {
					mToast = Toast.makeText(context, text, Toast.LENGTH_SHORT);
				} else {
					mToast.setText(text);
					mToast.setDuration(Toast.LENGTH_SHORT);
				}
				mToast.show();
			}
		} catch (Exception e) {
			ie(e);
		}
	}

	/**
	 * show long toast
	 * @param context context
	 * @param text    text
	 */
	public static void showLongMsg(Context context, @NonNull String text) {
		try {
			if (context != null) {
				if (mLongToast == null) {
					mLongToast = Toast.makeText(context, text, Toast.LENGTH_LONG);
				} else {
					mLongToast.setText(text);
					mLongToast.setDuration(Toast.LENGTH_LONG);
				}
				mLongToast.show();
			}
		} catch (Exception e) {
			ie(e);
		}
	}

	/**
	 * cancel current toast.
	 */
	public static void cancelToast() {
		if (mToast != null) {
			mToast.cancel();
			mToast = null;
		}
		if (mLongToast != null) {
			mLongToast.cancel();
			mLongToast = null;
		}
	}

	private static void ie(Exception e) {
		LogManager.getDefaultLogger().e(ToastUtil.class.getSimpleName(), e);
	}


}
