package org.tuzhao.library.tools;

import android.app.Activity;

import org.tuzhao.library.debug.LogManager;

/**
 * @author tuzhao
 *         Created by tuzhao on 16-1-20.
 */
public class TwoStack {

	private TwoStack() {
	}

	public static TwoStack instance;

	public static TwoStack getInstance() {
		if (instance == null) {
			instance = new TwoStack();
		}
		return instance;
	}

	private Activity contextOne;
	private Activity contextTwo;

	public void add(Activity context, int position) {
		switch (position) {
			case 1:
				contextOne = context;
				break;
			case 2:
				contextTwo = context;
				break;
		}
	}

	public void finish(int position) {
		switch (position) {
			case 1:
				if (contextOne != null) {
					it("two stack finish", contextOne.getClass().getSimpleName());
					contextOne.finish();
				}
				contextOne = null;
				break;
			case 2:
				if (contextTwo != null) {
					it("two stack finish", contextTwo.getClass().getSimpleName());
					contextTwo.finish();
				}
				contextTwo = null;
				break;
		}
	}

	public void release() {
		if (contextOne != null) {
			contextOne.finish();
		}
		contextOne = null;
		if (contextTwo != null) {
			contextTwo.finish();
		}
		contextTwo = null;
		instance = null;
		it("two stack", "release");
	}

	private void it(String tag, Object msg) {
		LogManager.getDefaultLogger().it(tag, msg);
	}


}
