package org.tuzhao.library.tools;

import android.content.Context;
import android.os.Environment;
import android.text.TextUtils;

import org.tuzhao.library.debug.LogManager;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

/**
 * @author tuzhao
 *         Created by tuzhao on 16-1-13.
 */
public class UtilTools {

	/**
	 * 判断当前app 是在后台运行还是在前台运行<br>
	 * 不需要额外的权限<br>
	 * @param context Context
	 * @return true 是在前台运行  false 是在后台运行  默认返回false
	 */
	public static boolean isAppInBackground(Context context) {
		android.app.ActivityManager activityManager = (android.app.ActivityManager) context.getSystemService(Context.ACTIVITY_SERVICE);
		List<android.app.ActivityManager.RunningAppProcessInfo> appProcesses = activityManager.getRunningAppProcesses();
		for (android.app.ActivityManager.RunningAppProcessInfo appProcess : appProcesses) {
			if (appProcess.processName.equals(context.getPackageName())) {
				if (appProcess.importance == android.app.ActivityManager.RunningAppProcessInfo.IMPORTANCE_BACKGROUND) {
					it("后台", appProcess.processName);
					return false;
				} else {
					it("前台", appProcess.processName);
					return true;
				}
			}
		}
		return false;
	}

	/**
	 * 判断一个service是否在运行
	 * @param context             Context
	 * @param serviceFullPathName 被判断service的全路径
	 * @return true 正在运行 false 没有运行
	 */
	public static boolean isServiceWorked(Context context, String serviceFullPathName) {
		android.app.ActivityManager myManager = (android.app.ActivityManager) context.getSystemService(Context.ACTIVITY_SERVICE);
		ArrayList<android.app.ActivityManager.RunningServiceInfo> runningService = (ArrayList<android.app.ActivityManager.RunningServiceInfo>) myManager.getRunningServices(30);
		if (!(runningService.size() > 0)) {
			it(serviceFullPathName + "---serviceState", false + "");
			return false;
		}
		for (int i = 0; i < runningService.size(); i++) {
			if (runningService.get(i).service.getClassName().equals(serviceFullPathName)) {
				it(serviceFullPathName + "---serviceState", true + "");
				return true;
			}
		}
		it(serviceFullPathName + "---serviceState", false + "");
		return false;
	}

	/**
	 * 获取指定文件夹名称的路径
	 * @param context    context
	 * @param folderName 指定的文件夹的名称
	 * @return 指定文件夹名称的路径
	 */
	@SuppressWarnings({"ConstantConditions", "ResultOfMethodCallIgnored"})
	public static String getUseAppPath(Context context, String folderName) {
		String path;
		if (Environment.getExternalStorageState().equals(Environment.MEDIA_MOUNTED)) {
			path = context.getExternalCacheDir().getAbsolutePath() + "/" + folderName;
		} else {
			path = context.getCacheDir().getAbsolutePath() + "/" + folderName;
		}
		File file = new File(path);
		if (!file.exists()) {
			file.mkdirs();
		}
		return path;
	}

	/**
	 * 专用函数来帮助您完成设备信息采集
	 * @param context Context
	 * @return device info
	 */
	public static String getDeviceInfo(Context context) {
		try {
			org.json.JSONObject json = new org.json.JSONObject();
			android.telephony.TelephonyManager tm = (android.telephony.TelephonyManager) context.getSystemService(Context.TELEPHONY_SERVICE);

			String device_id = tm.getDeviceId();

			android.net.wifi.WifiManager wifi = (android.net.wifi.WifiManager) context.getSystemService(Context.WIFI_SERVICE);

			String mac = wifi.getConnectionInfo().getMacAddress();
			json.put("mac", mac);

			if (TextUtils.isEmpty(device_id)) {
				device_id = mac;
			}

			if (TextUtils.isEmpty(device_id)) {
				device_id = android.provider.Settings.Secure.getString(context.getContentResolver(), android.provider.Settings.Secure.ANDROID_ID);
			}

			json.put("device_id", device_id);

			return json.toString();
		} catch (Exception e) {
			ie(e);
		}
		return null;
	}

	private static void it(String tag, Object msg) {
		LogManager.getDefaultLogger().it(tag, msg);
	}

	private static void ie(Exception e) {
		LogManager.getDefaultLogger().e(UtilTools.class.getSimpleName(), e);
	}

}
