package org.tuzhao.library.tools;

import android.content.Context;
import android.content.res.XmlResourceParser;

import org.tuzhao.library.debug.LogManager;
import org.xmlpull.v1.XmlPullParser;

import java.util.HashMap;
import java.util.LinkedHashMap;

/**
 * @author tuzhao
 *         Created by tuzhao on 16-2-1.
 */
public class XmlUtil {

	public static HashMap<String, String> getHashMap(Context c, int hashMapResId) {
		HashMap<String, String> map = null;
		XmlResourceParser parser = c.getResources().getXml(hashMapResId);

		String key = null, value = null;

		try {
			int eventType = parser.getEventType();
			while (eventType != XmlPullParser.END_DOCUMENT) {
				if (eventType == XmlPullParser.START_DOCUMENT) {
					it("XmlUtil", "start document");
				} else if (eventType == XmlPullParser.START_TAG) {
					if (parser.getName().equals("map")) {
						boolean isLinked = parser.getAttributeBooleanValue(null, "linked", false);
						map = isLinked ? new LinkedHashMap<String, String>() : new HashMap<String, String>();
					} else if (parser.getName().equals("entry")) {
						key = parser.getAttributeValue(null, "key");

						if (null == key) {
							parser.close();
							return null;
						}
					}
				} else if (eventType == XmlPullParser.END_TAG) {
					if (parser.getName().equals("entry")) {
						if (map != null) {
							map.put(key, value);
						}
						key = null;
						value = null;
					}
				} else if (eventType == XmlPullParser.TEXT) {
					if (null != key) {
						value = parser.getText();
					}
				}
				eventType = parser.next();
			}
		} catch (Exception e) {
			e.printStackTrace();
			return null;
		}
		return map;
	}

	private static void it(String tag, Object msg) {
		LogManager.getDefaultLogger().it(tag, msg);
	}

}
