package org.tuzhao.library.view;

import android.view.View;
import android.widget.AdapterView;

/**
 * 解决listView快速点击两次出现两次弹框的问题
 * @author tuzhao
 */
public abstract class BaseOneOnItemClickListener implements AdapterView.OnItemClickListener {

	private long lastTimeMillis;
	private long MIN_CLICK_INTERVAL = 1000;

	public BaseOneOnItemClickListener(long interval) {
		MIN_CLICK_INTERVAL = interval;
	}

	public BaseOneOnItemClickListener() {

	}

	private boolean isTimeEnabled() {
		long currentTimeMillis = System.currentTimeMillis();
		if ((currentTimeMillis - lastTimeMillis) > MIN_CLICK_INTERVAL) {
			lastTimeMillis = currentTimeMillis;
			return true;
		}
		return false;
	}

	@Override
	public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
		if (isTimeEnabled()) {
			click(parent, view, position, id);
		}
	}

	public abstract void click(AdapterView<?> parent, View view, int position, long id);
}
