package org.tuzhao.library.view;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.AnimationDrawable;
import android.support.v4.widget.SwipeRefreshLayout;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.widget.AbsListView;
import android.widget.ImageView;
import android.widget.ListView;

import org.tuzhao.library.R;

/**
 * 继承自SwipeRefreshLayout
 * 实现上拉加载更多
 * @author tuzhao
 */
public class SwipeRefreshLayoutForNormal extends SwipeRefreshLayout implements AbsListView.OnScrollListener {

	private int canScrollCount = Integer.MAX_VALUE;  //当前屏幕可以滚动的条数
	private int mTouchSlop;    //getScaledTouchSlop是一个距离，表示滑动的时候，手的移动要大于这个距离才开始移动控件。如果小于这个距离就不触发移动控件，
	private float firstTouchY;       //手指每次第一次按的位置
	private float lastTouchY;       //手指每次最后离开的位置
	private long fingerDownTime;
	private int defaultChildCount;  //默认包含的child个数

	private Activity context;
	private OnUpLoadListener mOnLoadListener;   //当前自定义的上拉加载的监听器

	private ListView mListView;    //当前包含的listview
	private View inflateFooterView;
	private View footerCompleteView;  //加载完成的footer view
	private View footerView;   //记载中的footer view
	private View footerMoreView;   //显示footer view

	public SwipeRefreshLayoutForNormal(Context context) {
		this(context, null);
		this.context = (Activity) context;
	}

	@SuppressLint("InflateParams")
	public SwipeRefreshLayoutForNormal(Context context, AttributeSet attrs) {
		super(context, attrs);
		if (!isInEditMode()) {
			this.context = (Activity) context;
			mTouchSlop = ViewConfiguration.get(context).getScaledTouchSlop() + 100;
			inflateFooterView = LayoutInflater.from(context).inflate(R.layout.loading_more_item_layout, null);
			footerView = inflateFooterView.findViewById(R.id.loading_footer_ll);
			footerCompleteView = inflateFooterView.findViewById(R.id.loading_complete_ll);
			footerMoreView = inflateFooterView.findViewById(R.id.loading_more_ll);
			footerCompleteView.setTag(false);
			footerMoreView.setTag(false);
			footerView.setTag(false);
			ImageView imageViewLoading = (ImageView) inflateFooterView.findViewById(R.id.imageViewLoading);
			AnimationDrawable animationDrawable = (AnimationDrawable) imageViewLoading.getBackground();
			animationDrawable.start();
		}
	}

	@Override
	protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
		super.onLayout(changed, left, top, right, bottom);
		// 初始化ListView对象
		if (mListView == null) {
			getListView();
		}
	}

	private void getListView() {
		int childs = getChildCount();
		if (childs > 0) {
			View childView = getChildAt(0);
			if (childView instanceof ListView) {
				this.mListView = (ListView) childView;
				mListView.setOnScrollListener(this);
				footerCompleteView.setVisibility(View.INVISIBLE);
				footerView.setVisibility(View.INVISIBLE);
				mListView.addFooterView(inflateFooterView);
				defaultChildCount = 1;
			}
		}
	}

	@Override
	public boolean dispatchTouchEvent(MotionEvent event) {
		final int action = event.getAction();
		switch (action) {
			case MotionEvent.ACTION_DOWN:
				fingerDownTime = System.currentTimeMillis();
				firstTouchY = event.getRawY();
				break;
			case MotionEvent.ACTION_MOVE:
				lastTouchY = (int) event.getRawY();
				break;
			case MotionEvent.ACTION_UP:
				long fingerUpTime = System.currentTimeMillis();
				if (!(fingerUpTime - fingerDownTime < 200 & lastTouchY - firstTouchY < 10)) {
					if (isCanLoadMore()) {
						loadData();
					}
				}
				break;
			default:
				break;
		}
		try {
			return super.dispatchTouchEvent(event);
		} catch (Exception e) {
			e.printStackTrace();
			return false;
		}
	}

	private boolean isCanLoadMore() {
		//当前footer view是否正在加载中
		if (!Boolean.parseBoolean(footerView.getTag().toString())) {
			//当前手势有上拉的动作
			if (isCanPullingUp()) {
				//当前listview是否处于底部
				if (isAtBottom()) {
					//当前listview是否可以在屏幕上滚动
					if (isCanScroll()) {
						return true;
					}
				}
			}
		}
		return false;
	}

	private boolean isCanPullingUp() {
		boolean result = (firstTouchY - lastTouchY) >= mTouchSlop;
		it("isCanPullingUp", String.valueOf(result));
		return result;
	}

	private boolean isAtBottom() {
		if (mListView != null) {
			if (mListView.getAdapter() != null) {
				if (mListView.getCount() > defaultChildCount) {
					if (mListView.getLastVisiblePosition() >= mListView.getAdapter().getCount() - 2 & mListView.getChildAt(mListView.getChildCount() - 2).getBottom() <= mListView.getHeight()) {
						it("isAtBottom", "true");
						return true;
					}
				}
			}
		}
		it("isAtBottom", "is not at bottom return false");
		return false;
	}

	private boolean isCanScroll() {
		if (mListView.getAdapter().getCount() - defaultChildCount > canScrollCount) {
			if (Boolean.parseBoolean(footerCompleteView.getTag().toString())) {
				footerCompleteView.setTag(false);
				footerCompleteView.setVisibility(View.INVISIBLE);
			}
			it("isCanScroll", "can scroll ! return true");
			return true;
		} else {
			it("isCanScroll", "can not scroll ! return false");
		}
		return false;
	}

	private void loadData() {
		if (mOnLoadListener != null) {
			setUpLoading(true);
			mOnLoadListener.onUpLoad();
		}
	}

	/**
	 * 设置当前listview包含的默认的child count
	 * @param defaultChildCount 默认的child count
	 */
	public void setDefaultChildCount(int defaultChildCount) {
		this.defaultChildCount = defaultChildCount;
	}

	/**
	 * 检是否显示加载完成的布局
	 * @param  maxSize maxSize
	 * @param  canScrollCount canScrollCount
	 */
	public void checkStateAndSetMaxSize(int maxSize, int canScrollCount) {
		it("canScrollCount", String.valueOf(canScrollCount));
		it("maxSize", String.valueOf(maxSize));
		it("defaultChildCount", String.valueOf(defaultChildCount));
		if (maxSize != 0) {
			this.canScrollCount = canScrollCount;
			if (mListView != null) {
				if (mListView.getAdapter() != null) {
					it("getCount", String.valueOf(mListView.getAdapter().getCount()));
					int tempCount = mListView.getAdapter().getCount() - defaultChildCount;

					if (tempCount == maxSize & tempCount > canScrollCount) {
						if (!Boolean.parseBoolean(footerCompleteView.getTag().toString())) {
							it("checkStateAndSetMaxSize", "show footerCompleteView ");
							footerCompleteView.setTag(true);
							footerCompleteView.setVisibility(View.VISIBLE);
						} else {
							it("checkStateAndSetMaxSize", "footerCompleteView is showing..");
						}
					} else {
						it("checkStateAndSetMaxSize", "footerCompleteView not reach count");
						footerCompleteView.setTag(false);
						footerCompleteView.setVisibility(View.INVISIBLE);
					}

					if (tempCount < maxSize & tempCount > canScrollCount) {
						footerMoreView.setVisibility(View.VISIBLE);
						footerMoreView.setTag(true);
						it("checkStateAndSetMaxSize", "show footerMoreView ");
					} else {
						footerMoreView.setVisibility(View.INVISIBLE);
						footerMoreView.setTag(false);
						it("checkStateAndSetMaxSize", "show footerMoreView  not reach count");
					}

				}
			}
		} else {
			it("checkStateAndSetMaxSize", "maxSize=0");
			footerCompleteView.setTag(false);
			footerMoreView.setTag(false);
			footerCompleteView.setVisibility(View.INVISIBLE);
			footerMoreView.setVisibility(View.INVISIBLE);
		}
	}

	/**
	 * 设置加载状态的footer view
	 */
	public void setLoadingFooterView() {
		@SuppressLint("InflateParams")
		View grayFooterView = context.getLayoutInflater().inflate(R.layout.loading_more_item_layout_for_search, null);
		ImageView loading_iv = (ImageView) grayFooterView.findViewById(R.id.loading_moer_for_search_imageViewLoading);
		AnimationDrawable loading_ad = (AnimationDrawable) loading_iv.getBackground();
		loading_ad.start();
		this.inflateFooterView = grayFooterView;

		footerView = grayFooterView.findViewById(R.id.loading_footer_ll);
		footerCompleteView = grayFooterView.findViewById(R.id.loading_complete_ll);
		footerMoreView = grayFooterView.findViewById(R.id.loading_more_ll);
		footerView.setTag(false);
		footerMoreView.setTag(false);
		footerCompleteView.setTag(false);
	}

	public void setUpLoading(boolean loading) {
		if (mListView == null) return;
		footerView.setTag(loading);
		if (Boolean.parseBoolean(footerView.getTag().toString())) {
			if (isRefreshing()) {
				setRefreshing(false);
			}
			if (Boolean.parseBoolean(footerMoreView.getTag().toString())) {
				footerMoreView.setTag(false);
				footerMoreView.setVisibility(View.INVISIBLE);
			}
			footerView.setVisibility(View.VISIBLE);
		} else {
			footerView.setVisibility(View.INVISIBLE);
			firstTouchY = 0;
			lastTouchY = 0;
		}
	}

	public void setOnUpLoadListener(OnUpLoadListener loadListener) {
		mOnLoadListener = loadListener;
	}

	@Override
	public void onScrollStateChanged(AbsListView view, int scrollState) {
		if (scrollState == SCROLL_STATE_IDLE) {
			// 滚动时到了最底部也可以加载更多
			if (isCanLoadMore()) {
				loadData();
			}
		}
	}

	@Override
	public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
	}

	public interface OnUpLoadListener {
		void onUpLoad();
	}

	private void it(String tag, Object msg) {

	}

}