package org.tuzhao.library.weak;

import java.lang.ref.WeakReference;

/**
 * 持有虚引用的Runnable
 * @author tuzhao
 *         Created by tuzhao on 16-4-8.
 */
public abstract class WeakRunnable<T> implements Runnable {

	private final WeakReference<T> wr;

	public WeakRunnable(T t) {
		wr = new WeakReference<>(t);
	}

	@Override
	public void run() {
		T t = wr.get();
		if (t != null) {
			weakRun(t);
		}
	}

	public abstract void weakRun(T t);

}
