package org.tuzhao.library.activity;

import android.app.Activity;
import android.content.Intent;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.v7.app.AppCompatActivity;
import android.text.TextUtils;
import android.view.View;
import android.view.WindowManager;
import android.widget.EditText;
import android.widget.TextView;

import org.tuzhao.library.annotion.AnnotationLayout;
import org.tuzhao.library.annotion.AnnotationView;
import org.tuzhao.library.debug.LogManager;
import org.tuzhao.library.helper.LoadingHelper;
import org.tuzhao.library.tools.SIntent;
import org.tuzhao.library.tools.SPUtil;
import org.tuzhao.library.tools.StringUtil;
import org.tuzhao.library.tools.TimeZoneUtil;
import org.tuzhao.library.tools.ToastUtil;
import org.tuzhao.library.tools.TwoStack;
import org.tuzhao.library.view.BaseOnClickListener;
import org.tuzhao.library.view.SingleOneOnClickListener;

import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.List;

/**
 * @author tuzhao
 *         Created by tuzhao on 16-3-16.
 */
public class MethodAppCompatActivity extends AppCompatActivity implements View.OnClickListener {

	/**
	 * find current activity content view just like method setContentView();
	 * @param context Activity
	 * @return root view
	 */
	protected View findContentView(@NonNull Activity context) {
		AnnotationLayout aLayout = context.getClass().getAnnotation(AnnotationLayout.class);
		if (aLayout != null) {
			View inflate = View.inflate(context, aLayout.value(), null);
			findChildView(context, inflate);
			return inflate;
		} else {
			throw new RuntimeException("current " + context.getClass().getSimpleName() + " can not find layout res Id!");
		}
	}

	/**
	 * find current activity child view just like method findViewById();
	 * @param context Activity
	 * @param inflate root view
	 */
	protected void findChildView(@NonNull Activity context, @NonNull View inflate) {
		Field[] declaredFields = context.getClass().getDeclaredFields();
		for (Field field : declaredFields) {
			field.setAccessible(true);
			AnnotationView aView = field.getAnnotation(AnnotationView.class);
			if (aView != null) {
				if (aView.value() != 0) {
					try {
						field.set(context, inflate.findViewById(aView.value()));
					} catch (IllegalAccessException e) {
						e.printStackTrace();
					}
				} else {
					throw new RuntimeException("current child view " + field.getName() + " resId is not correct !");
				}
			}
		}
	}

	public void setClick(@NonNull View... views) {
		for (View v : views) {
			v.setOnClickListener(this);
		}
	}

	public void setSingleClick(@NonNull View v, @NonNull SingleOneOnClickListener listener) {
		v.setOnClickListener(listener);
	}

	public void setSingleClick(@NonNull View v, @NonNull BaseOnClickListener listener) {
		v.setOnClickListener(listener);
	}

	/**
	 * get input from edit text
	 * @param et EditText
	 * @return input string
	 */
	public String getInput(@NonNull EditText et) {
		return et.getText().toString().trim();
	}

	/**
	 * judge string is empty
	 * @param des String
	 * @return true or false
	 */
	public boolean isEmpty(@NonNull String des) {
		return TextUtils.isEmpty(des);
	}

	/**
	 * 获取指定的颜色值
	 * @param colorId 颜色Id
	 * @return 颜色
	 */
	@SuppressWarnings("deprecation")
	public int getHue(int colorId) {
		return this.getResources().getColor(colorId);
	}

	/**
	 * get String form string.xml
	 * @param resId resource id
	 * @return string
	 */
	public String resString(int resId) {
		return this.getResources().getText(resId).toString();
	}

	public int dpPx(int rId) {
		return this.getResources().getDimensionPixelSize(rId);
	}

	public void hideInput() {
		getWindow().setSoftInputMode(WindowManager.LayoutParams.SOFT_INPUT_STATE_ALWAYS_HIDDEN);
	}

	public void startExtra(Class<? extends Activity> cls, Serializable... serializable) {
		startActivity(SIntent.s(this, cls, serializable));
	}

	public void startExtra(int requestCode, Class<? extends Activity> cls, Serializable... serializable) {
		startActivityForResult(SIntent.s(this, cls, serializable), requestCode);
	}

	public <T extends Serializable> T readExtra(Class<T> cls) {
		return SIntent.readSerializableExtra(this, cls);
	}

	@Override
	public void onClick(View v) {

	}

	public String activityName() {
		return this.getClass().getSimpleName();
	}

	public int parseInt(@NonNull String v) {
		return Integer.parseInt(v);
	}

	public void it(@NonNull String tag, @NonNull Object content) {
		LogManager.getDefaultLogger().it(tag, String.valueOf(content));
	}

	public void ie(@NonNull Exception e) {
		ie(activityName(), e);
	}

	public void ie(@NonNull String tag, @NonNull Exception e) {
		LogManager.getDefaultLogger().e(tag, e);
	}

	public void showMsg(@NonNull Object msg) {
		ToastUtil.showMsg(this, String.valueOf(msg));
	}

	public void showLongMsg(@NonNull String msg) {
		ToastUtil.showLongMsg(this, msg);
	}

	public void startProgressDialog() {
		LoadingHelper.getInstance().startProgressDialog(this);
	}

	public void stopProgressDialog() {
		LoadingHelper.getInstance().stopProgressDialog(this);
	}

	public void startProgressDesDialog(String des) {
		LoadingHelper.getInstance().startProgressDesDialog(this, des);
	}

	public void stopProgressDesDialog() {
		LoadingHelper.getInstance().stopProgressDesDialog(this);
	}

	public void clearTwoStack() {
		TwoStack.getInstance().release();
	}

	public boolean isRightMobile(@NonNull String mobile) {
		return StringUtil.isRightMobile(mobile);
	}

	public boolean isRightExpressNum(@NonNull String num) {
		return StringUtil.checkRightExpress(num);
	}

	public boolean isRightExpressNum(@NonNull String num, @NonNull String regex) {
		return StringUtil.checkRightExpress(num, regex);
	}

	public void saveBoolean(@NonNull String key, boolean data) {
		SPUtil.getInstance().saveBooleanOfSP(this, key, data);
	}

	public boolean getBoolean(@NonNull String key) {
		return SPUtil.getInstance().getBooleanOfSP(this, key);
	}

	public void saveString(@NonNull String key, @NonNull String data) {
		SPUtil.getInstance().saveStringOfSP(this, key, data);
	}

	public String getString(@NonNull String key) {
		return SPUtil.getInstance().getStringOfSP(this, key);
	}

	public String getString(Activity context, @NonNull String key) {
		return SPUtil.getInstance().getStringOfSP(context, key);
	}

	public void saveInt(@NonNull String key, int data) {
		SPUtil.getInstance().saveIntOfSP(this, key, data);
	}

	public int getInt(@NonNull String key) {
		return SPUtil.getInstance().getIntOfSP(this, key);
	}

	public void saveLong(@NonNull String key, long data) {
		SPUtil.getInstance().saveLongOfSP(this, key, data);
	}

	public long getLong(@NonNull String key) {
		return SPUtil.getInstance().getLongOfSP(this, key);
	}

	public void startActivity(Class<? extends Activity> c) {
		Intent intent = new Intent(this, c);
		startActivity(intent);
	}

	public void startActivity(Activity context, Class<? extends Activity> c) {
		Intent intent = new Intent(context, c);
		context.startActivity(intent);
	}

	public void startActivityC(Class<? extends Activity> c) {
		Intent intent = new Intent(this, c);
		startActivity(intent);
		finish();
	}

	public void startActivityC(Activity context, Class<? extends Activity> c) {
		Intent intent = new Intent(context, c);
		context.startActivity(intent);
		context.finish();
	}

	public void startActivityForResult(int requestCode, Class<? extends Activity> c) {
		ToastUtil.cancelToast();
		Intent intent = new Intent(this, c);
		startActivityForResult(intent, requestCode);
	}

	public void setVisible(@NonNull View... views) {
		for (View v : views) {
			if (v.getVisibility() != View.VISIBLE) {
				v.setVisibility(View.VISIBLE);
			}
		}
	}

	public void setInVisible(@NonNull View... views) {
		for (View v : views) {
			if (v.getVisibility() != View.INVISIBLE) {
				v.setVisibility(View.INVISIBLE);
			}
		}
	}

	public void setGone(@NonNull View... views) {
		for (View v : views) {
			if (v.getVisibility() != View.GONE) {
				v.setVisibility(View.GONE);
			}
		}
	}

	public void setTagNull(@NonNull View... views) {
		for (View v : views) {
			v.setTag(null);
		}
	}

	public void setTagFull(@NonNull View... views) {
		for (View v : views) {
			v.setTag(true);
		}
	}

	public boolean isTagNull(@NonNull View v) {
		return v.getTag() == null;
	}

	public boolean isTagFull(@NonNull View v) {
		return v.getTag() != null;
	}

	public boolean isListHas(@NonNull List<?> list) {
		return list.size() > 0;
	}

	public boolean isListEmpty(@NonNull List<?> list) {
		return list.size() == 0;
	}

	public void setText(@NonNull TextView t, @NonNull Object s) {
		t.setText(String.valueOf(s));
	}

	public void setTextColor(@NonNull TextView t, int colorId) {
		t.setTextColor(getHue(colorId));
	}

	public String trans(@NonNull String sourceTime) {
		return TimeZoneUtil.trans(sourceTime);
	}

	public void cleanObject(Object... objects) {
		for (Object o : objects) {
			if (o != null) {
				o = null;
			}
		}
	}

	public abstract static class WeakRunnable<T> implements Runnable {

		private final WeakReference<T> w;

		public WeakRunnable(T t) {
			this.w = new WeakReference<T>(t);
		}

		@Override
		public void run() {
			T t = w.get();
			if (t != null) {
				weakRun(t);
			}
		}

		public abstract void weakRun(T t);

	}

	public static abstract class WeakHandler<T> extends android.os.Handler {

		private final WeakReference<T> w;

		public WeakHandler(T t) {
			super();
			this.w = new WeakReference<T>(t);
		}

		public WeakHandler(T t, Looper looper) {
			super(looper);
			this.w = new WeakReference<T>(t);
		}

		@Override
		public void handleMessage(Message msg) {
			super.handleMessage(msg);
			T t = w.get();
			if (t != null) {
				weakMessage(msg, t);
			}
		}

		public abstract void weakMessage(Message msg, T t);

	}

}
