package org.tuzhao.library.application;

import android.app.Application;
import android.content.Context;
import android.support.multidex.MultiDex;
import android.support.v4.content.LocalBroadcastManager;


/**
 * @author tuzhao
 *         Created by tuzhao on 16-1-4.
 */
public class BaseApplication extends Application {

	private LocalBroadcastManager lbm;
	private Context applicationContext;

	@Override
	protected void attachBaseContext(Context base) {
		super.attachBaseContext(base);
		MultiDex.install(this);
	}

	@Override
	public void onCreate() {
		super.onCreate();
		applicationContext = getApplicationContext();
		lbm = LocalBroadcastManager.getInstance(this);
	}

	/**
	 * @return lbm
	 * 提供LocalBroadcastManager 实例
	 */
	public LocalBroadcastManager getLbm() {
		if (lbm == null) {
			lbm = LocalBroadcastManager.getInstance(getApplicationContext());
		}
		return lbm;
	}

	public Context getAppContext() {
		return applicationContext;
	}

}
