/**
 * Copyright 2015 bingoogolapple
 * <p/>
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * <p/>
 * http://www.apache.org/licenses/LICENSE-2.0
 * <p/>
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.tuzhao.library.badge;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.widget.TextView;

/**
 * 作者:王浩 邮件:bingoogolapple@gmail.com
 * 创建时间:15/7/6 下午3:04
 * 描述:
 */
public class BGABadgeTextView extends TextView implements BGABadgeable {
	private BGABadgeViewHelper mBadgeViewHelper;

	public BGABadgeTextView(Context context) {
		this(context, null);
	}

	public BGABadgeTextView(Context context, AttributeSet attrs) {
		this(context, attrs, android.R.attr.textViewStyle);
	}

	public BGABadgeTextView(Context context, AttributeSet attrs, int defStyleAttr) {
		super(context, attrs, defStyleAttr);
		mBadgeViewHelper = new BGABadgeViewHelper(this, context, attrs, BGABadgeViewHelper.BadgeGravity.RightCenter);
	}

	@Override
	public boolean onTouchEvent(MotionEvent event) {
		return mBadgeViewHelper.onTouchEvent(event);
	}

	@Override
	public boolean callSuperOnTouchEvent(MotionEvent event) {
		return super.onTouchEvent(event);
	}

	@Override
	protected void onDraw(Canvas canvas) {
		super.onDraw(canvas);
		mBadgeViewHelper.drawBadge(canvas);
	}

	@Override
	public void showCirclePointBadge() {
		mBadgeViewHelper.showCirclePointBadge();
	}

	@Override
	public void showTextBadge(String badgeText) {
		mBadgeViewHelper.showTextBadge(badgeText);
	}

	@Override
	public void hiddenBadge() {
		mBadgeViewHelper.hiddenBadge();
	}

	@Override
	public void showDrawableBadge(Bitmap bitmap) {
		mBadgeViewHelper.showDrawable(bitmap);
	}

	@Override
	public void setDragDismissDelegate(BGADragDismissDelegate delegate) {
		mBadgeViewHelper.setDragDismissDelegage(delegate);
	}
}