package org.tuzhao.library.debug;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Environment;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.Thread.UncaughtExceptionHandler;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * 处理异常基类
 * deal exception
 * @author tuzhao
 * @deprecated
 *         2016-01-08
 */
public abstract class CrashHandler implements UncaughtExceptionHandler {

	private final Context context;
	private final HashMap<String, String> infoMap = new HashMap<String, String>();
	private UncaughtExceptionHandler mDefaultHandler;

	public CrashHandler(Context context) {
		this.context = context;
		init();
	}

	private void init() {
		mDefaultHandler = Thread.getDefaultUncaughtExceptionHandler();
		Thread.setDefaultUncaughtExceptionHandler(this);
	}

	@Override
	public void uncaughtException(Thread thread, Throwable ex) {
		it("uncaughtException线程名字:", Thread.currentThread().getName());
		it("uncaughtException线程组:", Thread.currentThread().getThreadGroup().toString());

		if (!handleException(ex) & mDefaultHandler != null) {
			mDefaultHandler.uncaughtException(thread, ex);
			it("uncaughtException", "自定义异常处理失败");
			caughtExceptionFailure();
		} else {
			it("uncaughtException", "自定义异常处理成功");
			caughtExceptionSucc();
		}
	}

	//自定义异常处理方法
	private boolean handleException(Throwable ex) {
		if (ex == null) {
			return false;
		}
		String devInfo = getDeviceInfo(context);
		String crashInfo = getCrashInfo(ex);

		it("handleException", "设备信息:" + devInfo);
		it("handleException", "异常信息:" + crashInfo);

		saveCrashInfo(devInfo, crashInfo);
		API_UploadErrorInfo(devInfo, crashInfo);
		return true;
	}

	private void saveCrashInfo(String devInfo, String crashInfo) {
		if (devInfo == null | crashInfo == null) {
			it("saveCrashInfo", "save crashInfo failure!");
			return;
		}
		String path;
		if (Environment.getExternalStorageState().equals(Environment.MEDIA_MOUNTED)) {
			//noinspection ConstantConditions
			path = context.getExternalCacheDir().getAbsolutePath() + "/" + "exceptionLog";
		} else {
			path = context.getCacheDir().getAbsolutePath() + "/" + "exceptionLog";
		}

		File file = new File(path);
		if (!file.exists()) {
			//noinspection ResultOfMethodCallIgnored
			file.mkdirs();
		}

		@SuppressLint("SimpleDateFormat")
		SimpleDateFormat format = new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss");
		String time = format.format(new Date());
		String fileName = time + ".txt";

		FileOutputStream out = null;
		try {
			out = new FileOutputStream(path + "/" + fileName);
			out.write((devInfo + crashInfo).getBytes());
			it("异常信息保存成功", path + fileName);
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			if (out != null) {
				try {
					out.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
		}
	}

	//获得设备信息
	private String getDeviceInfo(Context context) {
		StringBuilder builder = new StringBuilder();

		int sdk = Build.VERSION.SDK_INT; // SDK号
		String model = Build.MODEL; // 手机型号
		String release = Build.VERSION.RELEASE; // android系统版本号

		builder.append("sdk号:").append(sdk).append(";\n");
		builder.append("手机型号:").append(model).append(";\n");
		builder.append("android系统版本号:").append(release).append(";\n");

		PackageManager packageManager = context.getPackageManager();
		try {
			PackageInfo packageInfo = packageManager.getPackageInfo(context.getPackageName(), PackageManager.GET_ACTIVITIES);
			if (packageInfo != null) {
				String versionName = packageInfo.versionName == null ? "versionName为null" : packageInfo.versionName;
				String versioncode = packageInfo.versionCode + "";
				infoMap.put("versionName", versionName);
				infoMap.put("versionCode", versioncode);
			}

			Field[] fields = Build.class.getDeclaredFields();
			for (Field field : fields) {
				field.setAccessible(true);
				infoMap.put(field.getName(), field.get(null).toString());
			}
		} catch (Exception e) {
			e.printStackTrace();
		}

		//这种形式获得键值对
		for (Map.Entry<String, String> entry : infoMap.entrySet()) {
			String key = entry.getKey();
			String value = entry.getValue();
			builder.append(key).append("=").append(value).append("\n");
		}

		return builder.toString();
	}

	//获得异常信息
	private String getCrashInfo(Throwable ex) {
		StringBuilder builder = new StringBuilder();

		builder.append(timeFormat(String.valueOf(System.currentTimeMillis())));
		builder.append("\n");

		Writer writer = new StringWriter();
		PrintWriter printWriter = new PrintWriter(writer);

		ex.printStackTrace(printWriter);
		Throwable cause = ex.getCause();
		while (cause != null) {
			cause.printStackTrace(printWriter);
			cause = cause.getCause();
		}
		printWriter.close();
		String result = writer.toString();
		builder.append(result);
		return builder.toString();
	}

	/**
	 * 将时间戳转为字符串  yyyy-MM-dd HH:mm:ss
	 * @param timeStamp 传递过来的参数单位为毫秒
	 */
	private String timeFormat(String timeStamp) {
		String re_StrTime;
		@SuppressLint("SimpleDateFormat")
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		long lcc_time = Long.valueOf(timeStamp);
		re_StrTime = sdf.format(new Date(lcc_time));
		return re_StrTime;
	}

	/**
	 * 自定义上传异常到服务器的方法
	 */
	public abstract void API_UploadErrorInfo(String devInfo, String crashInfo);

	/**
	 * 异常处理成功的方法
	 */
	public abstract void caughtExceptionSucc();

	/**
	 * 异常处理失败的方法
	 */
	public abstract void caughtExceptionFailure();

	public void it(String tag, Object msg) {
		LogManager.getDefaultLogger().it(tag, msg);
	}

}
