package org.tuzhao.library.debug;

import org.tuzhao.library.sync.SyncLinkedQueue;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

/**
 * @author tuzhao
 *         Created by tuzhao on 15-12-21.
 */
final class DebugThread extends Thread {

	/**
	 * the queue of DebugEntity
	 */
	private SyncLinkedQueue queue;
	/**
	 * the debug thread run flag,you can`t modify this by your self,only use  method closeDebugThread;
	 */
	private boolean threadRunFlag;

	public DebugThread() {
		queue = new SyncLinkedQueue();
		threadRunFlag = true;
	}

	@Override
	public void run() {
		while (threadRunFlag) {
			if (queue.isEmpty()) {
//				LogManager.getDefaultLogger().it("DebugThread", "wait add new data to debug thread.");
				synchronized (this) {
					try {
						wait();
					} catch (InterruptedException e) {
						e.printStackTrace();
					}
				}

			} else {
				DebugEntity entity = (DebugEntity) queue.remove();
//				LogManager.getDefaultLogger().it("DebugThread", "current save entity is:" + entity.toString());
				saveData(entity);
			}
		}

	}

	/**
	 * add new data into queue
	 * @param entity DebugEntity
	 */
	public void addData(DebugEntity entity) {
		queue.put(entity);
		synchronized (this) {
			notify();
		}
	}

	/**
	 * close debug thread.
	 */
	public void closeDebugThread() {
		threadRunFlag = false;
		notify();
	}

	/**
	 * 单线程任务轮询调用存储相关数据的方法
	 * @param entity DebugEntity
	 */
	private void saveData(DebugEntity entity) {
		File file = new File(entity.getPath());

		if (!file.exists()) {
			//noinspection ResultOfMethodCallIgnored
			file.mkdirs();
		}

		FileOutputStream out = null;
		try {
			out = new FileOutputStream(entity.getSaveName());
			out.write(entity.getParamsData().getBytes());
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			if (out != null) {
				try {
					out.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
		}
	}

}
