package org.tuzhao.library.debug;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Environment;

import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * @author tuzhao
 *         Created by tuzhao on 15-12-21.
 */
public class DebugUtil {

	/**
	 * current model: true is open,false is close;
	 */
	private volatile boolean model = false;
	private Context context;
	private static DebugUtil in;
	private DebugThread debugThread;
	private SimpleDateFormat sdf;

	private DebugUtil() {
	}

	public static DebugUtil getInstance() {
		if (in == null) {
			in = new DebugUtil();
		}
		return in;
	}

	public void init(Context context, boolean isOpen) {
		model = isOpen;
		((LoggerDefault) (LogManager.getDefaultLogger())).setModel(isOpen);
		if (model) {
			this.context = context;
			if (debugThread == null) {
				it("DebugUtil", "start a new debug thread!");
				debugThread = new DebugThread();
				debugThread.start();
			} else {
				if (!debugThread.isAlive()) {
					it("DebugUtil", "you have a debug thread,but is not running ,now starting ! ");
					debugThread.start();
				} else {
					it("DebugUtil", "you debug thread running normally!");
				}
			}
		}
	}

	public boolean getModel() {
		return model;
	}

	/**
	 * 存储Entity_Returns实体类的tostring
	 * @param requestData come form service
	 */
	public void saveRequestData(String requestData) {
		saveDetail("requestLog", requestData);
	}

	/**
	 * 存储本地产生的实体类tostring 如Entity_User
	 * @param localData come form app generate
	 */
	public void saveLocalData(String localData) {
		saveDetail("loacalLog", localData);
	}

	/**
	 * 存储联网发送的参数
	 * @param paramsData the params come from app send to service
	 */
	public void saveParamsData(String paramsData) {
		saveDetail("paramsLog", paramsData);
	}

	/**
	 * 存储实体类的tostring 跟上面的saveLocalData 有点重复
	 * @param msg entity
	 */
	public void saveEntityData(String msg) {
		saveDetail("entityLog", msg);
	}

	/**
	 * 保存心跳返回经过实体类解析的数据
	 * @param heartBeatRequestData heartBeatRequestData
	 */
	public void saveHeartBeatRequestData(String heartBeatRequestData) {
		saveDetail("heartBeatRequestLog", heartBeatRequestData);
	}

	/**
	 * 保存发送心跳的参数
	 * @param HeartBeatParamsData HeartBeatParamsData
	 */
	public void saveHeartBeatParmsData(String HeartBeatParamsData) {
		saveDetail("heartBeatParamsLog", HeartBeatParamsData);
	}

	/**
	 * 保存提示用户需要重新登录的数据
	 * @param userReloginRquestData userReloginRquestData
	 */
	public void saveUserReLoginData(String userReloginRquestData) {
		saveDetail("userReloginRequestLog", userReloginRquestData);

	}

	/**
	 * 保存原生 心跳的Json
	 * @param originalJson originalJson
	 */
	public void saveOriginalJsonOfHeartbeat(String originalJson) {
		saveDetail("originalJsonOfHeartbeat", originalJson);
	}

	/**
	 * 保存原生 正常请求的Json
	 * @param originalJson originalJson
	 */
	public void saveOriginalJsonOfNormalRequest(String originalJson) {
		saveDetail("originalJsonOfNormalRequest", originalJson);
	}


	/**
	 * all the save method detail
	 * @param directoryName directoryName
	 * @param data          data
	 */
	private void saveDetail(String directoryName, String data) {
		if (model) {
			if (checkInit()) {
				String path = getSavePath(directoryName);
				String fileName = getFileName();
				DebugEntity entity = new DebugEntity(path, path + "/" + fileName, data);
				debugThread.addData(entity);
			}
		}
	}

	/**
	 * get save file path
	 * @param type directory name
	 * @return path
	 */
	private String getSavePath(String type) {
		if (Environment.getExternalStorageState().equals(Environment.MEDIA_MOUNTED)) {
			//noinspection ConstantConditions
			return context.getExternalCacheDir().getAbsolutePath() + "/" + type;
		} else {
			return context.getCacheDir().getAbsolutePath() + "/" + type;
		}
	}

	/**
	 * get save file name  end with .txt
	 * @return fileName
	 */
	@SuppressLint("SimpleDateFormat")
	private String getFileName() {
		if (sdf == null) {
			sdf = new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss");
		}
		String time = sdf.format(new Date());
		return MessageFormat.format("{0}.txt", time);
	}

	/**
	 * check current debug util have init ?
	 */
	private boolean checkInit() {
		if (context == null) {
			throw new RuntimeException("you must init DebugUtil class at first !");
		} else {
			return true;
		}
	}

	private void it(String tag, Object msg) {
		LogManager.getDefaultLogger().it(tag, msg);
	}


}
