package org.tuzhao.library.debug;

import android.util.Log;

final class LoggerDefault implements Logger {

	private boolean model = true;

	/**
	 * set logger default model.
	 * @param model true open debug print    false close debug print
	 */
	public void setModel(boolean model) {
		this.model = model;
	}

	@Override
	public int v(String tag, String msg) {
		if (model) {
			return Log.v(tag, msg);
		} else {
			return -1;
		}
	}

	@Override
	public int v(String tag, String msg, Throwable tr) {
		if (model) {
			return Log.v(tag, msg, tr);
		} else {
			return -1;
		}
	}

	@Override
	public int vt(String tag, String msg) {
		if (model) {
			return Log.v("TAG", tag + "-->" + msg);
		} else {
			return -1;
		}
	}

	@Override
	public int d(String tag, String msg) {
		if (model) {
			return Log.d(tag, msg);
		} else {
			return -1;
		}
	}

	@Override
	public int d(String tag, String msg, Throwable tr) {
		if (model) {
			return Log.d(tag, msg, tr);
		} else {
			return -1;
		}
	}

	@Override
	public int dt(String tag, String msg) {
		if (model) {
			return Log.d("TAG", tag + "-->" + msg);
		} else {
			return -1;
		}
	}

	@Override
	public int i(String tag, String msg) {
		if (model) {
			return Log.i(tag, msg);
		} else {
			return -1;
		}
	}

	@Override
	public int i(String tag, String msg, Throwable tr) {
		if (model) {
			return Log.i(tag, msg, tr);
		} else {
			return -1;
		}
	}

	@Override
	public int it(String tag, Object msg) {
		if (model) {
			return Log.i("TAG", tag + "-->" + String.valueOf(msg));
		} else {
			return -1;
		}
	}

	@Override
	public int w(String tag, String msg) {
		if (model) {
			return Log.w(tag, msg);
		} else {
			return -1;
		}
	}

	@Override
	public int w(String tag, String msg, Throwable tr) {
		if (model) {
			return Log.w(tag, msg, tr);
		} else {
			return -1;
		}
	}

	@Override
	public int wt(String tag, String msg) {
		if (model) {
			return Log.w("TAG", tag + "-->" + msg);
		} else {
			return -1;
		}
	}

	@Override
	public int e(String tag, Exception e) {
		e.printStackTrace();
		return Log.e("TAG", tag + "-->" + e.toString());
	}

	@Override
	public int e(String tag, String msg) {
		if (model) {
			return Log.e(tag, msg);
		} else {
			return -1;
		}
	}

	@Override
	public int e(String tag, String msg, Throwable tr) {
		if (model) {
			return Log.e(tag, msg, tr);
		} else {
			return -1;
		}
	}

	@Override
	public int et(String tag, String msg) {
		if (model) {
			return Log.e("TAG", tag + "-->" + msg);
		} else {
			return -1;
		}
	}


}
