package org.tuzhao.library.dialog;

import android.app.Dialog;
import android.content.Context;
import android.graphics.drawable.AnimationDrawable;
import android.view.Gravity;
import android.widget.ImageView;

import org.tuzhao.library.R;

/**
 * 自定义dialog 实现loading效果<br>
 * @author tuzhao
 */
public class LoadOneDialog extends Dialog {

	private AnimationDrawable anim;

	public LoadOneDialog(Context context) {
		super(context);
		init(context);
	}

	public LoadOneDialog(Context context, int theme) {
		super(context, theme);
		init(context);
	}

	@SuppressWarnings("deprecation")
	private void init(Context app) {
		setContentView(R.layout.custom_dialog_progress);
		ImageView animIv = (ImageView) this.findViewById(R.id.loadingImageView);
		anim = (AnimationDrawable) animIv.getBackground();

		getWindow().getAttributes().gravity = Gravity.CENTER;
		setCancelable(false);
		setCanceledOnTouchOutside(false);
	}

	@Override
	public void onWindowFocusChanged(boolean hasFocus) {
		if (hasFocus) {
			if (anim != null) {
				if (!anim.isRunning()) {
					anim.start();
				}
			}
		}
	}

}