package org.tuzhao.library.dialog;

import android.app.Dialog;
import android.content.Context;
import android.graphics.drawable.AnimationDrawable;
import android.graphics.drawable.Drawable;
import android.view.Gravity;
import android.widget.ImageView;

import org.tuzhao.library.R;

/**
 * 自定义dialog 实现loading效果
 * @author tuzhao
 * @deprecated
 */
public class LoadingAnimDialog extends Dialog {
	private Context context;
	private static LoadingAnimDialog customProgressDialog = null;

	public LoadingAnimDialog(Context context) {
		super(context);
		this.context = context;
	}

	public LoadingAnimDialog(Context context, int theme) {
		super(context, theme);
		this.context = context;
	}

	public static LoadingAnimDialog createDialog(Context context) {
		customProgressDialog = new LoadingAnimDialog(context, R.style.CustomProgressDialog);
		customProgressDialog.setContentView(R.layout.custom_dialog_progress);
		customProgressDialog.getWindow().getAttributes().gravity = Gravity.CENTER;
		customProgressDialog.setCancelable(false);
		customProgressDialog.setCanceledOnTouchOutside(false);
		return customProgressDialog;
	}


	@Override
	public void onWindowFocusChanged(boolean hasFocus) {
		if (customProgressDialog == null) {
			return;
		}
		ImageView imageView = (ImageView) customProgressDialog.findViewById(R.id.loadingImageView);
		AnimationDrawable anim = new AnimationDrawable();

		for (int i = 1; i < 5; i++) {

			//根据资源名称和目录获取R.java中对应的资源ID
			int id = context.getResources().getIdentifier("loading_f" + i, "drawable", context.getPackageName());
			//根据资源ID获取到Drawable对象
			Drawable drawable = context.getResources().getDrawable(id);
			//将此帧添加到AnimationDrawable中
			anim.addFrame(drawable, 200);

		}

		anim.setOneShot(false);
		//noinspection deprecation
		imageView.setBackgroundDrawable(anim);
		anim.start();

	}

}