package org.tuzhao.library.recycler.decoration;

import android.app.Activity;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;

import org.tuzhao.library.R;

/**
 * 空白间隔的 decoration
 * @author tuzhao
 *         Created by tuzhao on 16-3-18.
 */
public class TransItemDecoration extends RecyclerView.ItemDecoration {

	private final int orientation = LinearLayoutManager.VERTICAL;
	private final Paint paint;
	private final int itemDividerSize;

	public TransItemDecoration(Activity context) {
		paint = new Paint(Paint.ANTI_ALIAS_FLAG);
		paint.setColor(Color.TRANSPARENT);
		paint.setStyle(Paint.Style.FILL);
		itemDividerSize = context.getResources().getDimensionPixelSize(R.dimen.recycler_divider_height);
	}

	/**
	 * 构建指定空白间隔的decoration
	 * @param context Activity
	 * @param gagSize 单位 px
	 */
	public TransItemDecoration(Activity context, int gagSize) {
		paint = new Paint(Paint.ANTI_ALIAS_FLAG);
		paint.setColor(Color.TRANSPARENT);
		paint.setStyle(Paint.Style.FILL);
		itemDividerSize = gagSize;
	}

	@Override
	public void onDraw(Canvas c, RecyclerView parent, RecyclerView.State state) {
		super.onDraw(c, parent, state);
		final int left = parent.getPaddingLeft();
		final int right = parent.getMeasuredWidth() - parent.getPaddingRight();
		final int childCount = parent.getChildCount();
		for (int i = 0; i < childCount; i++) {
			final View child = parent.getChildAt(i);
			RecyclerView.LayoutParams params = (RecyclerView.LayoutParams) child.getLayoutParams();
			final int top = child.getBottom() + params.bottomMargin;
			final int bottom = top + itemDividerSize;
			c.drawRect(left, top, right, bottom, paint);
		}
	}

	@Override
	public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
		super.getItemOffsets(outRect, view, parent, state);
		outRect.set(0, 0, 0, itemDividerSize);
	}

}
