package org.tuzhao.library.sync;

import org.tuzhao.library.debug.LogManager;

import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;

/**
 * @author tuzhao
 *         Created by tuzhao on 16-3-2.
 */
public class ThreadPoolUtil {

	private ThreadPoolUtil() {
		init();
	}

	private static ThreadPoolUtil instance = new ThreadPoolUtil();

	public static ThreadPoolUtil getInstance() {
		return instance;
	}

	private ThreadPoolExecutor fixedThreadPool;

	private void init() {
		fixedThreadPool = (ThreadPoolExecutor) Executors.newFixedThreadPool(4);
		it("ThreadPoolUtil", "init succ!");
	}

	public void execute(Runnable runnable) {
		detail();
		fixedThreadPool.execute(runnable);
		detail();
	}

	public void release() {
		if (fixedThreadPool != null) {
			fixedThreadPool.shutdownNow();
		}
	}

	public void detail() {
		it("active count", fixedThreadPool.getActiveCount());
		it("completed task count", fixedThreadPool.getCompletedTaskCount());
		it("core pool size", fixedThreadPool.getCorePoolSize());
		it("largest pool size", fixedThreadPool.getLargestPoolSize());
		it("poo size", fixedThreadPool.getPoolSize());
		it("maximum pool size", fixedThreadPool.getMaximumPoolSize());
		it("task count", fixedThreadPool.getTaskCount());
	}

	private void it(Object tag, Object msg) {
		LogManager.getDefaultLogger().it(String.valueOf(tag), msg);
	}


}
