package org.tuzhao.library.tools;

import android.app.Activity;
import android.support.annotation.Nullable;

import org.tuzhao.library.debug.LogManager;

import java.util.WeakHashMap;

/**
 * activity引用管理工具类
 * @author tuzhao
 *         Created by tuzhao on 16-4-18.
 */
public final class ActivityStack {

	private static final String TAG = "ActivityStack";

	private static final WeakHashMap<Activity, String> stack = new WeakHashMap<>();

	private static ActivityStack in;

	public static ActivityStack getStack() {
		if (in == null) {
			in = new ActivityStack();
			stack.clear();
		}
		return in;
	}

	private ActivityStack() {
		it("you create a new activity stack!");
	}

	public void add(@Nullable Activity key) {
		if (key == null)
			return;
		String v = key.getClass().getSimpleName();
		it("add activity is " + v);
		stack.put(key, v);
	}

	public String remove(@Nullable Activity key) {
		if (key == null)
			return "";
		return stack.remove(key);
	}

	public void close(@Nullable Activity key) {
		if (key == null)
			return;
		key.finish();
		remove(key);
	}

	public boolean containKey(@Nullable Activity key) {
		return stack.containsKey(key);
	}

	public boolean containValue(@Nullable String value) {
		return stack.containsValue(value);
	}

	public boolean isEmpty() {
		return stack.isEmpty();
	}

	public int size() {
		int size = stack.size();
		it("size is " + size);
		return size;
	}

	public void clear() {
		for (Activity activity : stack.keySet()) {
			if (activity != null)
				activity.finish();
		}
		stack.clear();
	}

	private void it(Object msg) {
		LogManager.getDefaultLogger().it(TAG, msg);
	}


}
