package org.tuzhao.library.tools;

import android.app.AlertDialog;
import android.content.Context;
import android.os.Build;

import java.lang.SuppressWarnings;

/**
 * @author tuzhao
 *         Created by tuzhao on 15-12-25.
 */
public class DialogUtil {

	private static DialogUtil in;

	private DialogUtil() {

	}

	public static DialogUtil intance() {
		if (in == null) {
			in = new DialogUtil();
		}
		return in;
	}

	@SuppressWarnings("deprecation")
	public AlertDialog.Builder getHoloLightBuilder(Context context) {
		if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.GINGERBREAD_MR1) {
			return new AlertDialog.Builder(context, AlertDialog.THEME_HOLO_LIGHT);
		} else {
			throw new RuntimeException("create holo light dialog need api level >=11 !");
		}
	}

	public android.app.AlertDialog getHoloLightDialog(Context context) {
		return getHoloLightBuilder(context).create();
	}

	public android.support.v7.app.AlertDialog.Builder getV7Builder(Context context) {
		return new android.support.v7.app.AlertDialog.Builder(context);
	}

	public android.support.v7.app.AlertDialog getV7Dialog(Context context) {
		return getV7Builder(context).create();
	}


}
