package org.tuzhao.library.tools;

import android.app.Activity;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.support.v4.graphics.drawable.RoundedBitmapDrawable;
import android.support.v4.graphics.drawable.RoundedBitmapDrawableFactory;

/**
 * convert resource to all kinds of drawable
 * @author tuzhao
 *         Created by tuzhao on 15-12-8.
 */
public class DrawableUtil {

	/**
	 * get rounded drawable
	 * @param context     Activity
	 * @param resId       resource id
	 * @param cornerAngle which corner angle do you want
	 * @return RoundedBitmapDrawable  (Drawable)
	 */
	public static RoundedBitmapDrawable getRoundedDrawable(Activity context, int resId, int cornerAngle) {
		Resources resources = context.getResources();
		Bitmap bitmap = BitmapFactory.decodeResource(resources, resId);
		RoundedBitmapDrawable roundedBitmapDrawable = RoundedBitmapDrawableFactory.create(resources, bitmap);
		roundedBitmapDrawable.getPaint().setAntiAlias(true);
		roundedBitmapDrawable.setCornerRadius(cornerAngle);
		return roundedBitmapDrawable;
	}

	/**
	 * get circle drawable
	 * @param context Activity
	 * @param resId   resource id
	 * @return RoundedBitmapDrawable  (Drawable)
	 */
	public static RoundedBitmapDrawable getCircleDrawable(Activity context, int resId) {
		Resources resources = context.getResources();
		Bitmap bitmap = BitmapFactory.decodeResource(resources, resId);
		RoundedBitmapDrawable roundedBitmapDrawable = RoundedBitmapDrawableFactory.create(resources, bitmap);
		roundedBitmapDrawable.getPaint().setAntiAlias(true);
		roundedBitmapDrawable.setCornerRadius((Math.max(bitmap.getHeight(), bitmap.getWidth())) / 2.0f);
		return roundedBitmapDrawable;
	}


}
