package org.tuzhao.library.tools;

import android.app.Activity;
import android.os.Handler;

import org.tuzhao.library.debug.LogManager;

import java.io.File;
import java.util.ArrayList;

/**
 * 文件删除线程
 * @author tuzhao
 *         2016-1-8
 */
public abstract class FileCleanThread extends Thread {

	private final String[] cleanPath;
	private final String[] dirArray;

	public FileCleanThread(Activity activity, String... path) {
		cleanPath = path;
		this.dirArray = new String[]{"requestLog", "loacalLog", "paramsLog", "entityLog", "HeartBeatRequestLog",
			"HeartBeatParamsLog", "userReloginRequestLog", "originalJsonOfHeartbeatLog",
			"originalJsonOfNormalRequest", "exceptionLog", "scanImg", "upImgCache"};
	}

	public FileCleanThread(Handler handler, String... path) {
		cleanPath = path;
		this.dirArray = new String[]{"requestLog", "loacalLog", "paramsLog", "entityLog", "HeartBeatRequestLog",
			"HeartBeatParamsLog", "userReloginRequestLog", "originalJsonOfHeartbeatLog",
			"originalJsonOfNormalRequest", "exceptionLog", "scanImg", "upImgCache"};
	}

	public FileCleanThread(String... path) {
		cleanPath = path;
		this.dirArray = new String[]{"requestLog", "loacalLog", "paramsLog", "entityLog", "HeartBeatRequestLog",
			"HeartBeatParamsLog", "userReloginRequestLog", "originalJsonOfHeartbeatLog",
			"originalJsonOfNormalRequest", "exceptionLog", "scanImg", "upImgCache"};
	}

	@Override
	public void run() {
		super.run();

		ArrayList<String> cleanList = new ArrayList<>();
		if (cleanPath != null) {
			for (String p : cleanPath) {
				if (p != null) {
					for (String d : dirArray) {
						cleanList.add(p + "/" + d);
					}
				}
			}
		}

		if (cleanList.size() > 0) {
			for (String c : cleanList) {
				File file = new File(c);
				deleteFile(file);
			}
		}

		try {
			Thread.sleep(3000);
		} catch (InterruptedException e) {
			e.printStackTrace();
		}

		deleteComplete();
		it("deleteComplete", "succ");
	}

	/**
	 * 递归删除 文件/文件夹
	 * @param file 当前传递过来的file对象
	 */
	private void deleteFile(File file) {
		if (file != null) {
			if (file.exists()) {
				if (file.isFile()) {
					//noinspection ResultOfMethodCallIgnored
					file.delete();
				} else if (file.isDirectory()) {
					File files[] = file.listFiles();
					if (files != null) {
						for (File item : files) {
							deleteFile(item);
						}
					}
				}
			} else {
				it("delete file no exists ", file.getAbsolutePath());
			}
		}
	}

	public abstract void deleteComplete();

	private void it(String tag, String msg) {
		LogManager.getDefaultLogger().it(tag, msg);
	}

}
