package org.tuzhao.library.tools;

import android.content.Context;
import android.os.Environment;

import org.tuzhao.library.debug.LogManager;

import java.io.File;
import java.util.ArrayList;

/**
 * 文件删除线程
 * @author tuzhao
 * @deprecated
 *         2016-1-8
 */
public abstract class FileDeleteThread extends Thread {

	private Context context;
	private String[] dirArray;

	private String outSidePath;
	private String inSidePath;

	public FileDeleteThread(Context context) {
		this.context = context;
		this.dirArray = new String[]{"requestLog", "loacalLog", "paramsLog", "entityLog", "HeartBeatRequestLog",
			"HeartBeatParamsLog", "userReloginRequestLog", "originalJsonOfHeartbeatLog",
			"originalJsonOfNormalRequest", "exceptionLog", "scanImg", "upImgCache"};

		new Thread(this, "FileDeleteThread").start();
	}

	public FileDeleteThread(Context context, String[] dirArray) {
		this.context = context;
		this.dirArray = dirArray;
		new Thread(this, "FileDeleteThread").start();
	}

	@Override
	public void run() {
		super.run();

		prepare();

		it("prepareFileDelete---outSidePath", outSidePath);
		it("prepareFileDelete---inSidePath", inSidePath);

		try {
			Thread.sleep(3000);
		} catch (InterruptedException e) {
			e.printStackTrace();
		}

		deleteFileOut();
		it("deleteFileOut", "succ");

		try {
			Thread.sleep(3000);
		} catch (InterruptedException e) {
			e.printStackTrace();
		}

		deleteFileIn();
		it("deleteFileIn", "succ");

		try {
			Thread.sleep(3000);
		} catch (InterruptedException e) {
			e.printStackTrace();
		}

		deleteComplete();
		it("deleteComplete", "succ");
	}

	private void prepare() {
		if (Environment.getExternalStorageState().equals(Environment.MEDIA_MOUNTED)) {
			//noinspection ConstantConditions
			outSidePath = context.getExternalCacheDir().getAbsolutePath();
		}
		inSidePath = context.getCacheDir().getAbsolutePath();
	}

	/**
	 * 删除外置存储的缓存文件
	 */
	private void deleteFileOut() {
		ArrayList<String> outSideList;
		if (outSidePath != null) {
			outSideList = new ArrayList<String>();
			for (String aDirArray : dirArray) {
				outSideList.add(outSidePath + "/" + aDirArray);
			}

			for (int j = 0; j < outSideList.size(); j++) {
				File file = new File(outSideList.get(j));
				deleteFile(file);
			}
		}
	}

	/**
	 * 删除内置存储的缓存文件
	 */
	private void deleteFileIn() {
		ArrayList<String> inSideList = new ArrayList<String>();
		for (String aDirArray : dirArray) {
			inSideList.add(inSidePath + "/" + aDirArray);
		}

		for (int j = 0; j < inSideList.size(); j++) {
			File file = new File(inSideList.get(j));
			deleteFile(file);
		}

	}

	/**
	 * 递归删除 文件/文件夹
	 * @param file 当前传递过来的file对象
	 */
	private void deleteFile(File file) {
		if (file == null) {
			return;
		}
		it("delete file path=", file.getAbsolutePath());
		if (file.exists()) {
			if (file.isFile()) {
				//noinspection ResultOfMethodCallIgnored
				file.delete();
			} else if (file.isDirectory()) {
				File files[] = file.listFiles();
				if (files != null) {
					for (File itemFIle : files) {
						deleteFile(itemFIle);
					}
				}
			}
		} else {
			it("delete file no exists ", file.getAbsolutePath());
		}
	}

	public abstract void deleteComplete();

	private void it(String tag, String msg) {
		LogManager.getDefaultLogger().it(tag, msg);
	}

}
