package org.tuzhao.library.tools;

import android.content.Context;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.DecimalFormat;

/**
 * @author tuzhao
 *         Created by tuzhao on 16-1-12.
 */
public class FileUtil {

	/**
	 * 将制定文件的内容读取出来
	 * @param context Context
	 * @param rawId   资源文件ID
	 * @return 返回读取文件的内容  以字符串的形式返回
	 */
	public static String readRawFile(Context context, int rawId) {
		try {
			InputStream inputStream = context.getResources().openRawResource(rawId);
			InputStreamReader reader = new InputStreamReader(inputStream);
			char[] chars = new char[30];
			StringBuilder sb = new StringBuilder();
			while ((reader.read(chars)) != -1) {
				for (char aChar : chars) {
					sb.append(aChar);
				}
			}
			inputStream.close();
			return sb.toString();
		} catch (Exception e) {
			e.printStackTrace();
			return "";
		}
	}

	/**
	 * 转换文件大小  小数点后两位
	 * @param fileS byte
	 * @return String
	 */
	public static String getConvertFileSizeTwo(long fileS) {
		DecimalFormat df = new DecimalFormat("#.00");
		String fileSizeString = "";
		if (fileS < 1024) {
			fileSizeString = df.format((double) fileS) + "Byte";
		} else if (fileS < 1048576) {
			fileSizeString = df.format((double) fileS / 1024) + "KB";
		} else if (fileS < 1073741824) {
			fileSizeString = df.format((double) fileS / 1048576) + "MB";
		} else {
			fileSizeString = df.format((double) fileS / 1073741824) + "GB";
		}
		return fileSizeString;
	}


}
