package org.tuzhao.library.tools;

import android.annotation.SuppressLint;
import android.text.TextUtils;

import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * 时间格式化工具类
 * @author tuzhao
 *         Created by tuzhao on 16-3-1.
 */
@SuppressLint("SimpleDateFormat")
public class FormatUtil {

	private static SimpleDateFormat fileNameSdf;
	private static SimpleDateFormat sdf1;
	private static SimpleDateFormat sdf2;

	/**
	 * 格式化当前时间为指定后缀的文件名
	 * @param type like .txt .db ......
	 * @return file name
	 */
	public static String getFileName(String type) {
		if (fileNameSdf == null) {
			fileNameSdf = new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss");
		}
		String time = fileNameSdf.format(new Date(TimeZoneUtil.getChinaCurrentMils()));
		return time + type;
	}

	/**
	 * 将时间戳转为字符串  yyyy-MM-dd HH:mm:ss
	 * @param timeStamp 传递过来的参数单位为毫秒
	 * @return 格式化后的时间戳
	 */
	public static String formatTime1(String timeStamp) {
		if (timeStamp == null) {
			return "----";
		}
		if (TextUtils.isEmpty(timeStamp)) {
			return "----";
		}
		if (timeStamp.equals("-1")) {
			return "----";
		}
		if (sdf1 == null) {
			sdf1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		}
		return sdf1.format(new Date(Long.valueOf(timeStamp)));
	}

	/**
	 * @return 今天日期
	 */
	public static String formatToday() {
		if (sdf2 == null) {
			sdf2 = new SimpleDateFormat("yyyy-MM-dd");
		}
		return sdf2.format(new Date(TimeZoneUtil.getChinaCurrentMils()));
	}

	public static void release() {
		fileNameSdf = null;
		sdf1 = null;
		sdf2 = null;
	}

}
