package org.tuzhao.library.tools;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;

/**
 * @author tuzhao
 *         Created by tuzhao on 16-1-8.
 */
public class InfoUtil {

	private static PackageInfo packageInfo;

	/**
	 * 获得程序版本
	 * @param context Context
	 * @return app version name
	 */
	public static String getAppVersionName(Context context) {
		String vName = "";
		try {
			if (packageInfo == null) {
				packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
			}
			vName = packageInfo.versionName;
		} catch (PackageManager.NameNotFoundException e) {
			e.printStackTrace();
		}
		return vName;
	}

	/**
	 * 获得当前app的VersionCode
	 * @param context Context
	 * @return app version code
	 */
	public static int getAppVersionCode(Context context) {
		int vCode = 0;
		try {
			if (packageInfo == null) {
				packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
			}
			vCode = packageInfo.versionCode;
		} catch (PackageManager.NameNotFoundException e) {
			e.printStackTrace();
		}
		return vCode;
	}

}
