package org.tuzhao.library.tools;

import android.app.Activity;

import org.tuzhao.library.debug.LogManager;

import java.util.Stack;

/**
 * 应用程序Activity管理类：用于Activity管理和应用程序退出
 * @author liux (http://my.oschina.net/liux)
 * @version 1.0
 * @deprecated
 */
public final class ManagerActivity {

	private static Stack<Activity> activityStack;
	private static ManagerActivity instance;

	private ManagerActivity() {
	}

	/**
	 * 单一实例
	 * @return ManagerActivity instance
	 */
	public static ManagerActivity getAppManager() {
		if (instance == null) {
			instance = new ManagerActivity();
			it("getAppManager", "you create a new activity stack !");
		}
		return instance;
	}

	/**
	 * 添加Activity到堆栈
	 * @param activity activity
	 */
	public void addActivity(Activity activity) {
		if (activityStack == null) {
			activityStack = new Stack<Activity>();
		}
		it("addActivity()", "add new activity instance " + activity.getClass().getSimpleName());
		activityStack.add(activity);
	}

	/**
	 * 获取当前Activity（堆栈中最后一个压入的）
	 * @return current activity
	 */
	public Activity currentActivity() {
		return activityStack.lastElement();
	}

	/**
	 * 结束当前Activity（堆栈中最后一个压入的）
	 */
	public void finishActivity() {
		Activity activity = activityStack.lastElement();
		if (activity != null) {
			it("finishActivity()", "remove a activity instance " + activity.getClass().getSimpleName());
			finishActivity(activity);
		} else {
			it("finishActivity()", "exit current activity fail because get current activity is null !");
		}
	}

	/**
	 * 结束指定的Activity
	 * @param activity activity
	 */
	public void finishActivity(Activity activity) {
		if (activity != null) {
			activityStack.remove(activity);
			activity.finish();
			activity = null;
		} else {
			it("finishActivity(activity)", "exit current activity fail because get current activity is null !");
		}
	}

	/**
	 * 结束指定类名的Activity
	 * @param cls class
	 */
	public void finishActivity(Class<?> cls) {
		for (Activity activity : activityStack) {
			if (activity.getClass().equals(cls)) {
				finishActivity(activity);
			}
		}
	}

	/**
	 * 结束所有Activity
	 */
	public void finishAllActivity() {
		if (activityStack != null) {
			for (int i = 0, size = activityStack.size(); i < size; i++) {
				if (null != activityStack.get(i)) {
					Activity activity = activityStack.get(i);
					if (!activity.isFinishing()) {
						activity.finish();
						it(activity.getClass().getName(), "has finish()");
					}
				}
			}
			activityStack.clear();
		} else {
			it("finishAllActivity()", "activityStack is null !");
		}
	}

	public void removeLast() {
		if (activityStack != null) {
			if (activityStack.size() > 0) {
				size();
				Activity activity = activityStack.lastElement();
				String name = activity.getClass().getSimpleName();
				it("remove activity name is", name);
				activityStack.remove(activityStack.lastElement());
				size();
			}
		}
	}

	public int size() {
		int size = activityStack.size();
		it("size", size);
		return size;
	}

	private static void it(String tag, Object msg) {
		LogManager.getDefaultLogger().it(tag, msg);
	}

}