package org.tuzhao.library.tools;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Environment;
import android.os.Handler;
import android.os.Message;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ProgressBar;
import android.widget.TextView;

import org.tuzhao.library.R;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.MessageFormat;

/**
 * 检查更新的工具类
 * @author tuzhao
 *         2016-01-18
 */
public abstract class ManagerUpdate {

	private Activity context;
	private Handler myHandler;

	private int progress;
	private String downUrl;

	private String apkNameRelease;
	private String apkNameTemp;

	private String pathRelease;

	private ProgressBar mProgressBar;
	private TextView mProgressTv;
	private AlertDialog progressDialog;
	private String apkFileSize;
	private String tmpFileSize;

	public ManagerUpdate(Activity context) {
		this.context = context;
		initHandler();
	}

	private void initHandler() {
		myHandler = new Handler(context.getMainLooper(), new Handler.Callback() {
			@Override
			public boolean handleMessage(Message msg) {
				switch (msg.what) {
					case 1:
						mProgressBar.setProgress(progress);
						mProgressTv.setText(MessageFormat.format("{0}/{1}", tmpFileSize, apkFileSize));
						break;
					case 2:
						closeDialog();
						installApk();
						break;
					case 3:
						closeDialog();
						showMsg("无法下载安装文件,请检查SD卡是否挂载!");
						break;
					case 4:
						closeDialog();
						showMsg("下载文件异常,请联系开发人员!");
						break;
					case 5:
						closeDialog();
						showMsg("下载文件重命名失败,请联系开发人员!");
						break;
				}
				return false;
			}
		});
	}

	private void closeDialog() {
		if (progressDialog != null) {
			progressDialog.dismiss();
		}
	}

	public void startDownloadApk(String versionName, String downUrl) {
		apkNameRelease = "station_ebox_" + versionName + ".apk";
		apkNameTemp = "station_ebox_" + versionName + ".tmp";
		this.downUrl = downUrl;

		AlertDialog.Builder builder= DialogUtil.intance().getHoloLightBuilder(context);
		@SuppressLint("InflateParams")
		View v = LayoutInflater.from(context).inflate(R.layout.dialog_update_progress, null);
		mProgressBar = (ProgressBar) v.findViewById(R.id.dialog_update_progress_bar);
		mProgressTv = (TextView) v.findViewById(R.id.dialog_update_progress_des_tv);
		builder.setView(v);
		builder.setCancelable(false);
		progressDialog = builder.create();
		progressDialog.setCanceledOnTouchOutside(false);
		progressDialog.show();

		new downloadApkThread().start();
	}

	private class downloadApkThread extends Thread {

		@Override
		public void run() {

			String state = Environment.getExternalStorageState();
			if (!state.equals(Environment.MEDIA_MOUNTED)) {
				myHandler.sendEmptyMessage(3);
				return;
			}

			String path = getUseAppPath(context, "app");
			pathRelease = path + "/" + apkNameRelease;
			String pathTemp = path + "/" + apkNameTemp;

			File fileRelease = new File(pathRelease);
			if (fileRelease.exists()) {
				myHandler.sendEmptyMessage(2);
				return;
			}

			try {
				URL url = new URL(downUrl);
				HttpURLConnection conn = (HttpURLConnection) url.openConnection();
				conn.connect();
				int length = conn.getContentLength();
				InputStream is = conn.getInputStream();

				File fileTemp = new File(pathTemp);
				FileOutputStream fos = new FileOutputStream(fileTemp);

				DecimalFormat df = new DecimalFormat("0.00");
				apkFileSize = df.format((float) length / 1024 / 1024) + "MB";

				int count = 0;
				byte buf[] = new byte[1024];
				do {
					int numRead = is.read(buf);
					count += numRead;

					tmpFileSize = df.format((float) count / 1024 / 1024) + "MB";
					progress = (int) (((float) count / length) * 100);
					myHandler.sendEmptyMessage(1);

					if (numRead <= 0) {
						if (fileTemp.renameTo(fileRelease)) {
							myHandler.sendEmptyMessage(2);
						} else {
							myHandler.sendEmptyMessage(5);
						}
						break;
					}

					fos.write(buf, 0, numRead);
				} while (true);
				fos.close();
				is.close();
			} catch (Exception e) {
//				it("Exception", e.getMessage());
				myHandler.sendEmptyMessage(4);
			}
		}
	}

	/**
	 * 安装APK文件
	 */
	private void installApk() {
		File apkFile = new File(pathRelease);
		if (!apkFile.exists()) {
			showMsg("apk文件不存在\n刚下载就被删除了?!");
		} else {
//			String[] args1 = {"chmod", "777", mSavePath};
//			String result1 = exec(args1);
//			it("result1", result1);

			String[] args2 = {"chmod", "777", pathRelease};
			String result2 = exec(args2);
//			it("result2", result2);

			Intent intent = new Intent(Intent.ACTION_VIEW);
			intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
			intent.setDataAndType(Uri.parse("file://" + apkFile.toString()), "application/vnd.android.package-archive");
			context.startActivity(intent);
			startInstall(context);
		}
	}

	private String exec(String[] args) {
		String result = "";
		ProcessBuilder processBuilder = new ProcessBuilder(args);
		Process process = null;
		InputStream errIs = null;
		InputStream inIs = null;
		try {
			ByteArrayOutputStream baos = new ByteArrayOutputStream();
			int read;
			process = processBuilder.start();
			errIs = process.getErrorStream();
			while ((read = errIs.read()) != -1) {
				baos.write(read);
			}
			baos.write('\n');
			inIs = process.getInputStream();
			while ((read = inIs.read()) != -1) {
				baos.write(read);
			}
			byte[] data = baos.toByteArray();
			result = new String(data);
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			try {
				if (errIs != null) {
					errIs.close();
				}
				if (inIs != null) {
					inIs.close();
				}
			} catch (IOException e) {
				e.printStackTrace();
			}
			if (process != null) {
				process.destroy();
			}
		}
		return result;
	}

	@SuppressWarnings({"ConstantConditions", "ResultOfMethodCallIgnored"})
	private String getUseAppPath(Context context, String folderName) {
		String path;
		if (Environment.getExternalStorageState().equals(Environment.MEDIA_MOUNTED)) {
			path = context.getExternalCacheDir().getAbsolutePath() + "/" + folderName;
		} else {
			path = context.getCacheDir().getAbsolutePath() + "/" + folderName;
		}
		File file = new File(path);
		if (!file.exists()) {
			file.mkdirs();
		}
		return path;
	}

	/**
	 * <h3>显示版本更新的dialog</h3>
	 * 在这里定义你的dialog显示
	 * @param mContext Activity
	 */
	public abstract void showVersionDialog(Activity mContext);

	/**
	 * 当开始执行安装时后调用的方法<br>
	 * 你可以在这里执行一些操作，比如kill当前app的进程，不然某些手机安装时会报错！
	 * @param context Activity
	 */
	public abstract void startInstall(Activity context);

	public void showMsg(String msg) {
		ToastUtil.showMsg(context, msg);
	}

}
