package org.tuzhao.library.tools;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;

import org.tuzhao.library.debug.LogManager;

/**
 * @author tuzhao
 *         Created by tuzhao on 16-1-4.
 */
public class NetUtil {

	private static ConnectivityManager mConnectivityManager;

	/**
	 * 判断是否有网络连接
	 * @param context context
	 * @return true or false
	 */
	public static boolean isHaveNet(Context context) {
		if (context != null) {

			if (mConnectivityManager == null) {
				mConnectivityManager = (ConnectivityManager) context.getSystemService(Context.CONNECTIVITY_SERVICE);
			}
			NetworkInfo mNetworkInfo = mConnectivityManager.getActiveNetworkInfo();
			if (mNetworkInfo != null) {
				it("isHaveNet", "state--" + mNetworkInfo.isAvailable());
				return mNetworkInfo.isAvailable();
			}
		}
		it("isHaveNet", "state--false!! has no network!");
		return false;
	}

	/**
	 * 判断wifi网络时候可用
	 * @param context context
	 * @return true or false
	 */
	public static boolean isWifiConnected(Context context) {
		if (context != null) {
			ConnectivityManager mConnectivityManager = (ConnectivityManager) context.getSystemService(Context.CONNECTIVITY_SERVICE);
			NetworkInfo mWiFiNetworkInfo = mConnectivityManager.getNetworkInfo(ConnectivityManager.TYPE_WIFI);
			if (mWiFiNetworkInfo != null) {
				return mWiFiNetworkInfo.isAvailable();
			}
		}
		return false;
	}

	/**
	 * 判断手机移动网络是否可用
	 * @param context context
	 * @return true or false
	 */
	public static boolean isMobileConnected(Context context) {
		if (context != null) {
			ConnectivityManager mConnectivityManager = (ConnectivityManager) context.getSystemService(Context.CONNECTIVITY_SERVICE);
			NetworkInfo mMobileNetworkInfo = mConnectivityManager.getNetworkInfo(ConnectivityManager.TYPE_MOBILE);
			if (mMobileNetworkInfo != null) {
				return mMobileNetworkInfo.isAvailable();
			}
		}
		return false;
	}

	private static void it(String tag, Object msg) {
		LogManager.getDefaultLogger().it(tag, msg);
	}

}
