package org.tuzhao.library.tools;

import android.app.Activity;
import android.content.Context;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;

/**
 * @author tuzhao
 *         Created by tuzhao on 16-1-8.
 */
public class ResUtil {

	/**
	 * get color value form xml
	 * @param context Context
	 * @param resId   resource id
	 * @return value id
	 */
	public static int getColor(Context context, int resId) {
		//noinspection deprecation
		return context.getResources().getColor(resId);
	}

	/**
	 * 读取assets目录下的文件
	 * @param context  activity
	 * @param fileName 具体的某个文件名 如"area.json"
	 * @return 将当前文件已字符串的形式返回
	 */
	public static String readAssets(Activity context, String fileName) {
		String content;
		try {
			InputStream in = context.getAssets().open(fileName);
			byte[] buffer = new byte[1024];
			ByteArrayOutputStream out = new ByteArrayOutputStream();
			int length;
			while ((length = in.read(buffer)) != -1) {
				out.write(buffer, 0, length);
			}
			content = new String(out.toByteArray());
			in.close();
			out.close();
		} catch (Exception e) {
			e.printStackTrace();
			content = null;
		}
		return content;
	}

	/**
	 * 将raw文件的内容读取出来
	 * @param context Context
	 * @param rawId   资源文件ID R.raw.xxx
	 * @return 返回读取文件的内容  以字符串的形式返回
	 */
	public static String readFile(Context context, int rawId) {
		try {
			InputStream inputStream = context.getResources().openRawResource(rawId);
			InputStreamReader reader = new InputStreamReader(inputStream);
			char[] tempchars = new char[128];
			StringBuilder sb = new StringBuilder();
			while (reader.read(tempchars) != -1) {
				for (char c : tempchars) {
					sb.append(c);
				}
			}
			inputStream.close();
			return sb.toString();
		} catch (Exception e) {
			e.printStackTrace();
			return null;
		}
	}


}
