package org.tuzhao.library.tools;

import android.content.Context;
import android.content.SharedPreferences;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/**
 * 这个类主要是处理当前app 的SharedPreferences
 * @author tuzhao
 */
public class SPUtil {

	private String appSpTag = "DEFAULT_APP";

	public static SPUtil sp = new SPUtil();

	private SPUtil() {

	}

	public static SPUtil getInstance() {
		return sp;
	}


	/**
	 * 存储指定指定名称 指定值
	 * @param context context
	 * @param type    指定名称
	 * @param value   指定值
	 * @return false 存储失败  true 存储成功
	 */
	public boolean saveStringOfSP(Context context, String type, String value) {
		SharedPreferences sp = context.getSharedPreferences(appSpTag, Context.MODE_PRIVATE);
		SharedPreferences.Editor editor = sp.edit();
		editor.putString(type, value);
		return editor.commit();
	}


	/**
	 * 存储map类型的偏好设置
	 * @param context context
	 * @param map     key String value String
	 * @return false 存储失败  true 存储成功
	 */
	public boolean saveMapOfSPKSVS(Context context, HashMap<String, String> map) {
		SharedPreferences sp = context.getSharedPreferences(appSpTag, Context.MODE_PRIVATE);
		SharedPreferences.Editor editor = sp.edit();
		Iterator<Map.Entry<String, String>> iterator = map.entrySet().iterator();
		while (iterator.hasNext()) {
			Map.Entry<String, String> entry = iterator.next();
			editor.putString(entry.getKey(), entry.getValue());
		}
		return editor.commit();
	}


	/**
	 * 存储指定名称的偏好设置  针对value为boolean类型
	 * @param context context
	 * @param type    type
	 * @param value   value
	 * @return false 存储失败  true 存储成功
	 */
	public boolean saveBooleanOfSP(Context context, String type, boolean value) {
		SharedPreferences sp = context.getSharedPreferences(appSpTag, Context.MODE_PRIVATE);
		SharedPreferences.Editor editor = sp.edit();
		editor.putBoolean(type, value);
		return editor.commit();
	}


	/**
	 * 存储指定名称的偏好设置  针对value为int类型
	 * @param context context
	 * @param type    type
	 * @param value   value
	 * @return false 存储失败  true 存储成功
	 */
	public boolean saveIntOfSP(Context context, String type, int value) {
		SharedPreferences sp = context.getSharedPreferences(appSpTag, Context.MODE_PRIVATE);
		SharedPreferences.Editor editor = sp.edit();
		editor.putInt(type, value);
		return editor.commit();
	}

	public boolean saveLongOfSP(Context context, String type, long value) {
		SharedPreferences sp = context.getSharedPreferences(appSpTag, Context.MODE_PRIVATE);
		SharedPreferences.Editor editor = sp.edit();
		editor.putLong(type, value);
		return editor.commit();
	}


	/**
	 * 针对值为字符串类型
	 * 获取指定名称的sp 的值  默认返回值为空
	 * @param context context
	 * @param type    context
	 * @return 默认返回值为""
	 */
	public String getStringOfSP(Context context, String type) {
		SharedPreferences sp = context.getSharedPreferences(appSpTag, Context.MODE_PRIVATE);
		return sp.getString(type, "");
	}


	/**
	 * 针对值为布尔值类型
	 * 获取指定名称的sp 的值  默认返回值为false
	 * @param context Context
	 * @param type    要查询的key
	 * @return 默认返回值为false
	 */
	public boolean getBooleanOfSP(Context context, String type) {
		SharedPreferences sp = context.getSharedPreferences(appSpTag, Context.MODE_PRIVATE);
		return sp.getBoolean(type, false);
	}


	/**
	 * 针对值为int类型
	 * 获取指定名称的sp 的值  默认返回值为空
	 * @param context context
	 * @param type    type
	 * @return 默认返回值为0;
	 */
	public int getIntOfSP(Context context, String type) {
		SharedPreferences sp = context.getSharedPreferences(appSpTag, Context.MODE_PRIVATE);
		return sp.getInt(type, 0);
	}

	public long getLongOfSP(Context context, String type) {
		SharedPreferences sp = context.getSharedPreferences(appSpTag, Context.MODE_PRIVATE);
		return sp.getLong(type, 0);
	}

	/**
	 * 针对值为int类型
	 * 获取指定名称的sp 的值  默认返回值为空
	 * @param context context
	 * @param type    type
	 * @return 默认返回值为0;
	 */
	public int getIntOfSPAppType(Context context, String type) {
		SharedPreferences sp = context.getSharedPreferences(appSpTag, Context.MODE_PRIVATE);
		return sp.getInt(type, 2);
	}


}
