package org.tuzhao.library.tools;

import android.app.Activity;
import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.media.Ringtone;
import android.media.RingtoneManager;
import android.media.SoundPool;
import android.net.Uri;

import org.tuzhao.library.R;
import org.tuzhao.library.debug.LogManager;

import java.io.IOException;

/**
 * @author tuzhao
 *         Created by tuzhao on 15-12-22.
 */
public class SoundUtil {

	private static SoundUtil instance = new SoundUtil();

	private SoundPool soundPool;
	private Uri notificationUri;
	private Ringtone ringtone;

	private SoundUtil() {
	}

	public static SoundUtil getInstance() {
		return instance;
	}

	/**
	 * init type of Ringtone,you can use method play() to play sound.
	 * @param context Activity
	 * @return Ringtone
	 */
	public Ringtone initRingtone(Activity context) {
		Uri notification = RingtoneManager.getDefaultUri(RingtoneManager.TYPE_NOTIFICATION);
		return RingtoneManager.getRingtone(context, notification);
	}

	/**
	 * <h3>初始化SoundPool</h3>
	 * init type of  SoundPool,you can user method play(loadId, 1.0f, 1.0f, 0, 0, 1.0f) to play sound.<br>
	 * but you must have loadId! loadId = soundPool.load(this, R.raw.beep, 1);<br>
	 * after play ,you must use method release() to release resource.<br>
	 * @return SoundPool
	 */
	public SoundPool initSoundPool() {
//		The content of the comments need API-21
//		SoundPool.Builder builder=new SoundPool.Builder();
//		builder.setMaxStreams(10);
//
//		AudioAttributes.Builder audioBuilder=new AudioAttributes.Builder();
//		audioBuilder.setContentType(AudioAttributes.CONTENT_TYPE_UNKNOWN);
//		audioBuilder.setFlags(AudioAttributes.FLAG_AUDIBILITY_ENFORCED);
//		audioBuilder.setLegacyStreamType(AudioManager.STREAM_SYSTEM);
//		audioBuilder.setUsage(AudioAttributes.USAGE_NOTIFICATION);
//		AudioAttributes attributes = audioBuilder.build();
//
//		builder.setAudioAttributes(attributes);
//		SoundPool soundPool = builder.build();

		if (soundPool == null) {
			//noinspection deprecation
			soundPool = new SoundPool(10, AudioManager.STREAM_NOTIFICATION, 5);
			it("init sound pool", "sound pool is null");
		} else {
			it("init sound pool", "sound pool is not null");
		}
		return soundPool;
	}

	/**
	 * <h3>谨慎使用</h3>
	 * 强制重新初始化 SoundPool
	 * @param maxStreams maxStreams  eg:10
	 * @param streamType streamType  eg:AudioManager.STREAM_NOTIFICATION
	 * @param srcQuality srcQuality  eg:5
	 * @return SoundPool
	 */
	public SoundPool forceInitSoundPool(int maxStreams, int streamType, int srcQuality) {
		soundPool = null;
		//noinspection deprecation
		soundPool = new SoundPool(maxStreams, streamType, srcQuality);
		return soundPool;
	}

	/**
	 * 加载要播放的声音到系统中
	 * @param context Activity
	 * @param rawId   R.raw.xxx
	 * @return 加载到系统中的声音缓存id
	 */
	public int load(Context context, int rawId) {
		int loadId;
		if (soundPool != null) {
			loadId = soundPool.load(context.getApplicationContext(), rawId, 1);
		} else {
			loadId = -1;
			it("sound pool load", "failure! sound pool is null !");
		}
		return loadId;
	}

	/**
	 * 播放指定id的声音
	 * @param loadId 加载到系统中的声音缓存id
	 */
	public void play(int loadId) {
		if (soundPool != null) {
			soundPool.play(loadId, 1.0f, 1.0f, 0, 0, 1.1f);
		} else {
			it("sound pool play", "failure! sound pool is null !");
		}
	}

	/**
	 * init type of  MediaPlayer, use method start() to play sound.
	 * after play ,you must use method release() to release resource.
	 * @param context Activity
	 * @param rawId   the id of raw
	 * @return MediaPlayer
	 */
	public MediaPlayer initMediaPlayer(Activity context, int rawId) {
		/**
		 *  The volume on STREAM_SYSTEM is not adjustable, and users found it too loud,so we now play on the music stream.
		 */
		context.setVolumeControlStream(AudioManager.STREAM_MUSIC);
		final MediaPlayer mediaPlayer = new MediaPlayer();
		mediaPlayer.setAudioStreamType(AudioManager.STREAM_MUSIC);
		/**
		 * When the beep has finished playing, rewind to queue up another one.
		 */
		mediaPlayer.setOnCompletionListener(new MediaPlayer.OnCompletionListener() {
			@Override
			public void onCompletion(MediaPlayer mp) {
				mediaPlayer.seekTo(0);
			}
		});
		mediaPlayer.setOnErrorListener(new MediaPlayer.OnErrorListener() {
			@Override
			public boolean onError(MediaPlayer mp, int what, int extra) {
				mediaPlayer.release();
				return true;
			}
		});
		AssetFileDescriptor file;
		if (rawId == 0) {
			file = context.getResources().openRawResourceFd(R.raw.beep);
		} else {
			file = context.getResources().openRawResourceFd(rawId);
		}
		try {
			mediaPlayer.setDataSource(file.getFileDescriptor(), file.getStartOffset(), file.getLength());
			file.close();
			float BEEP_VOLUME = 1.0f;
			mediaPlayer.setVolume(BEEP_VOLUME, BEEP_VOLUME);
			mediaPlayer.prepare();
		} catch (IOException e) {
			e.printStackTrace();
			it("initSpecifiedSound", "what happened to init sound? you need to deal it .");
			return null;
		}
		return mediaPlayer;
	}

	/**
	 * 播放系统默认提示声音
	 * @param context context
	 */
	public void playNotificationSound(Context context) {
		if (notificationUri == null) {
			notificationUri = RingtoneManager.getDefaultUri(RingtoneManager.TYPE_NOTIFICATION);
		}
		if (ringtone == null) {
			ringtone = RingtoneManager.getRingtone(context, notificationUri);
		}
		ringtone.play();
	}

	/**
	 * <h3> 释放SoundUtil使用到的所有资源</h3>
	 * 1.释放SoundPool<br>
	 * 2.清空当前工具类的instance<br>
	 */
	public void release() {
		if (soundPool != null) {
			soundPool.release();
		}
		soundPool = null;
	}

	private void it(Object tag, Object msg) {
		LogManager.getDefaultLogger().it(String.valueOf(tag), msg);
	}


}
