package org.tuzhao.library.tools;

import android.support.annotation.NonNull;
import android.text.TextUtils;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * <h3>字符串操作相关工具类</h3>
 * 涉及到字符串格式化，正则表达式验证等等<br>
 * @author tuzhao
 *         Created by tuzhao on 16-1-14.
 */
public class StringUtil {

	private static Pattern pattern;
	private static Pattern tempPattern;
	private static String tempRegex;

	/**
	 * 检查是否是正确的快递单号
	 * @param expressNum 快递单号
	 * @return true 是  false 不是
	 */
	public static boolean checkRightExpress(@NonNull String expressNum) {
		boolean flag;
		try {
			String check = "^\\w{10,30}$";
			if (pattern == null) {
				pattern = Pattern.compile(check);
			}
			Matcher matcher = pattern.matcher(expressNum);
			flag = matcher.matches();
		} catch (Exception e) {
			flag = false;
		}
		return flag;
	}

	/**
	 * 根据指定的正则表达式匹配是否时正确的快件单号
	 * @param ex    快递单号
	 * @param regex 正则表达式
	 * @return true 是  false 不是
	 */
	public static boolean checkRightExpress(@NonNull String ex, @NonNull String regex) {
		if (TextUtils.isEmpty(regex)) {
			return true;
		} else {
			boolean createFlag;
			if (tempRegex != null) {
				createFlag = !tempRegex.equals(regex);
			} else {
				tempRegex = regex;
				createFlag = true;
			}
			try {
				if (createFlag) {
					tempPattern = Pattern.compile(regex);
				} else {
					if (tempPattern == null) {
						tempPattern = Pattern.compile(regex);
					}
				}
				return tempPattern.matcher(ex).matches();
			} catch (Exception e) {
				e.printStackTrace();
				return false;
			}
		}
	}

	/**
	 * 将元数据前补零，补后的总长度为指定的长度，以字符串的形式返回
	 * @param num    需要补零的数字
	 * @param length 补零之后总的长度
	 * @return 补零之后的字符串
	 */
	public static String formatWithZero(int num, int length) {
		return String.format("%0" + length + "d", num);
	}

	/**
	 * 验证是否是特定长度的数字
	 * @param num           输入的数字
	 * @param startPosition 起始长度
	 * @param endPosition   结束长度
	 * @return true 符合 false 不符合
	 */
	public static boolean isNumber(String num, int startPosition, int endPosition) {
		boolean flag = false;
		try {
			String check = "^\\d{" + startPosition + "," + endPosition + "}$";
			Pattern regex = Pattern.compile(check);
			Matcher matcher = regex.matcher(num);
			flag = matcher.matches();
		} catch (Exception e) {
			flag = false;
		}
		return flag;
	}

	/**
	 * 将指定的数字格式化为小数点后两位长度
	 * @param value number
	 * @return 格式化后的字符串
	 */
	public static String formatPointTwo(double value) {
		return String.format(Locale.CHINESE, "%.2f", value);
	}

	/**
	 * 将浮点数格式化为整数
	 * @param value double
	 * @return 格式化后整数
	 */
	public static String formatInteger(double value) {
		return String.format(Locale.CHINESE, "%.0f", value);
	}

	/**
	 * 验证手机格式
	 * @param mobile String
	 * @return 合法的手机号这返回true  不合法则返回false
	 */
	public static boolean isRightMobile(String mobile) {
		String telRegex = "[1][34578]\\d{9}";
		if (!TextUtils.isEmpty(mobile)) {
			return mobile.matches(telRegex);
		} else {
			return false;
		}
	}

	/**
	 * 释放StringUtil使用到的所有资源
	 */
	public static void release() {
		pattern = null;
		tempPattern = null;
		tempRegex = null;
	}


}
