package org.tuzhao.library.tools;

import android.annotation.SuppressLint;
import android.text.TextUtils;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

/**
 * only use in timezone, get right time to you want timezone id.
 * @author tuzhao
 *         Created by tuzhao on 15-12-7.
 */
public class TimeZoneUtil {

	/**
	 * default timezone id;
	 */
	public static final String defaultTimeZoneId = "Asia/Shanghai";

	public static SimpleDateFormat sdf;
	private static TimeZone defaultTimeZone;
	private static TimeZone chinaTimeZone;
	private static SimpleDateFormat sdf3;

	/**
	 * get right timestamp that you specified timezone displayName
	 * @param zoneName you want trans specified timezone displayName;   "GMT+8"
	 * @param source   source timestamp  linux timestamp
	 * @return timestamp
	 */
	public static String getSpecifiedTimezoneTimestamp(String zoneName, String source) {
		if (source == null || TextUtils.isEmpty(source)) {
			return "-1";
		}
		if (TimeZone.getDefault().getID().equals(defaultTimeZoneId)) {
//			Log.i("TAG", "currentTimeZoneId.equals(Asia/Shanghai)");
			return source;
		} else {
			TimeZone chinaZone = TimeZone.getTimeZone(zoneName);
			long rightTime = (Long.parseLong(source) * 1000 - TimeZone.getDefault().getRawOffset() + chinaZone.getRawOffset()) / 1000;
			return String.valueOf(rightTime);
		}
	}

	/**
	 * @return get current system timezone id
	 */
	public static String getSystemTimezoneId() {
		return TimeZone.getDefault().getID();
	}

	/**
	 * @return get current system timezone displayName
	 */
	public static String getSystemTimezoneName() {
		return TimeZone.getDefault().getDisplayName();
	}

	@SuppressLint("SimpleDateFormat")
	public static String trans(String source) {
		if (source == null || TextUtils.isEmpty(source)) {
			return "----";
		}
		if (source.equals("-1")) {
			return "----";
		}
		String time = getSpecifiedTimezoneTimestamp("GMT+8", source);
		long lTime = Long.parseLong(time) * 1000;
		if (sdf == null) {
			sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		}
		return sdf.format(new Date(lTime));
	}

	@SuppressLint("SimpleDateFormat")
	public static String trans3(String source) {
		if (source == null || TextUtils.isEmpty(source)) {
			return "----";
		}
		if (source.equals("-1")) {
			return "----";
		}
		String time = getSpecifiedTimezoneTimestamp("GMT+8", source);
		long lTime = Long.parseLong(time) * 1000;
		if (sdf3 == null) {
			sdf3 = new SimpleDateFormat("yyyy-MM-dd\nHH:mm:ss");
		}
		return sdf3.format(new Date(lTime));
	}

	/**
	 * 获取中国时区当前的毫秒时间戳
	 * @return 中国时区当前的毫秒时间戳
	 */
	public static long getChinaCurrentMils() {
		long currentMils = System.currentTimeMillis();
		if (defaultTimeZone == null) {
			defaultTimeZone = TimeZone.getDefault();
		}
		if (defaultTimeZone.getID().equals("Asia/Shanghai")) {
			return currentMils;
		}
		if (defaultTimeZone.getID().equals("Asia/Chongqing")) {
			return currentMils;
		}
		if (chinaTimeZone == null) {
			chinaTimeZone = TimeZone.getTimeZone("GMT+8");
		}
		return currentMils - TimeZone.getDefault().getRawOffset() + chinaTimeZone.getRawOffset();
	}

	@SuppressLint("SimpleDateFormat")
	public static String trans2(String source) {
		if (source == null || TextUtils.isEmpty(source)) {
			return "----";
		}
		if (source.equals("-1")) {
			return "----";
		}
		String time = getSpecifiedTimezoneTimestamp2("GMT+8", source);
		long lTime = Long.parseLong(time);
		if (sdf == null) {
			sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		}
		return sdf.format(new Date(lTime));
	}

	public static String getSpecifiedTimezoneTimestamp2(String zoneName, String source) {
		if (source == null || TextUtils.isEmpty(source)) {
			return "-1";
		}
		if (TimeZone.getDefault().getID().equals(defaultTimeZoneId)) {
//			Log.i("TAG", "currentTimeZoneId.equals(Asia/Shanghai)");
			return source;
		} else {
			TimeZone chinaZone = TimeZone.getTimeZone(zoneName);
			long rightTime = (Long.parseLong(source) - TimeZone.getDefault().getRawOffset() + chinaZone.getRawOffset());
			return String.valueOf(rightTime);
		}
	}


}
