package org.tuzhao.library.view;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Toast;

/**
 * @author tuzhao
 *         Created by tuzhao on 15-12-30.
 */
public class MyToast extends Toast {

	private Context context;
	private int layoutId;
	private int time;  //Toast.LENGTH_LONG
	private int gravity;   //Gravity.CENTER

	public MyToast(Context context) {
		super(context);
	}

	public MyToast(Context context, int layoutId, int time, int gravity) {
		super(context);
		this.context = context;
		this.layoutId = layoutId;
		this.time = time;
		this.gravity = gravity;
		init();
	}

	private void init() {
		if (context == null) {
			throw new RuntimeException("you need show toast , so you can`t give me a null context!");
		}
		View view = LayoutInflater.from(context).inflate(layoutId, null);
		setDuration(time);
		setView(view);
		setGravity(gravity, 0, 0);
	}


}
