/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.twister2;

import edu.iu.dsc.tws.api.tset.TSetEnvironment;
import edu.iu.dsc.tws.api.tset.sets.TSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.beam.runners.core.construction.SerializablePipelineOptions;
import org.apache.beam.runners.core.construction.TransformInputs;
import org.apache.beam.runners.twister2.Twister2PipelineOptions;
import org.apache.beam.runners.twister2.translators.functions.Twister2SinkFunction;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;

public class Twister2TranslationContext {
    private final Twister2PipelineOptions options;
    protected final Map<PValue, TSet<?>> dataSets = new LinkedHashMap();
    private final Set<TSet> leaves = new LinkedHashSet<TSet>();
    private final Map<PCollectionView<?>, TSet<?>> sideInputDataSets;
    private AppliedPTransform<?, ?, ?> currentTransform;
    private final TSetEnvironment environment;
    private final SerializablePipelineOptions serializableOptions;

    public SerializablePipelineOptions getSerializableOptions() {
        return this.serializableOptions;
    }

    public Twister2TranslationContext(Twister2PipelineOptions options) {
        this.options = options;
        this.environment = options.getTSetEnvironment();
        this.sideInputDataSets = new HashMap();
        this.serializableOptions = new SerializablePipelineOptions((PipelineOptions)options);
    }

    public <T extends PValue> T getOutput(PTransform<?, T> transform) {
        return (T)((PValue)Iterables.getOnlyElement(this.currentTransform.getOutputs().values()));
    }

    public PipelineOptions getOptions() {
        return this.options;
    }

    public <T> void setOutputDataSet(PCollection<T> output, TSet<WindowedValue<T>> tset) {
        if (!this.dataSets.containsKey(output)) {
            this.dataSets.put((PValue)output, tset);
            this.leaves.add(tset);
        }
    }

    public <T> TSet<WindowedValue<T>> getInputDataSet(PValue input) {
        TSet<?> tSet = this.dataSets.get(input);
        this.leaves.remove(tSet);
        return tSet;
    }

    public <T> Map<TupleTag<?>, PValue> getInputs() {
        return this.currentTransform.getInputs();
    }

    public <T extends PValue> T getInput(PTransform<T, ?> transform) {
        return (T)((PValue)Iterables.getOnlyElement((Iterable)TransformInputs.nonAdditionalInputs(this.currentTransform)));
    }

    public void setCurrentTransform(AppliedPTransform<?, ?, ?> transform) {
        this.currentTransform = transform;
    }

    public AppliedPTransform<?, ?, ?> getCurrentTransform() {
        return this.currentTransform;
    }

    public Map<TupleTag<?>, PValue> getOutputs() {
        return this.getCurrentTransform().getOutputs();
    }

    public Map<TupleTag<?>, Coder<?>> getOutputCoders() {
        return this.currentTransform.getOutputs().entrySet().stream().filter(e -> e.getValue() instanceof PCollection).collect(Collectors.toMap(Map.Entry::getKey, e -> ((PCollection)e.getValue()).getCoder()));
    }

    public TSetEnvironment getEnvironment() {
        return this.environment;
    }

    public void execute() {
        for (TSet leaf : this.leaves) {
            leaf.direct().sink(new Twister2SinkFunction());
        }
    }

    public <VT, ET> void setSideInputDataSet(PCollectionView<VT> value, TSet<WindowedValue<ET>> set) {
        if (!this.sideInputDataSets.containsKey(value)) {
            this.sideInputDataSets.put(value, set);
        }
    }
}

