/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.twister2.translators.batch;

import edu.iu.dsc.tws.api.tset.sets.batch.BBaseTSet;
import edu.iu.dsc.tws.api.tset.sets.batch.ComputeTSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.beam.runners.core.construction.ParDoTranslation;
import org.apache.beam.runners.twister2.Twister2BatchTranslationContext;
import org.apache.beam.runners.twister2.translators.BatchTransformTranslator;
import org.apache.beam.runners.twister2.translators.functions.DoFnFunction;
import org.apache.beam.runners.twister2.translators.functions.OutputTagFilter;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.DoFnSchemaInformation;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.reflect.DoFnSignature;
import org.apache.beam.sdk.transforms.reflect.DoFnSignatures;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Maps;

public class ParDoMultiOutputTranslatorBatch<IT, OT>
implements BatchTransformTranslator<ParDo.MultiOutput<IT, OT>> {
    @Override
    public void translateNode(ParDo.MultiOutput<IT, OT> transform, Twister2BatchTranslationContext context) {
        TupleTag mainOutputTag;
        DoFn doFn = transform.getFn();
        BBaseTSet inputTTSet = context.getInputDataSet((PValue)context.getInput(transform));
        WindowingStrategy windowingStrategy = ((PCollection)context.getInput(transform)).getWindowingStrategy();
        Coder inputCoder = ((PCollection)context.getInput(transform)).getCoder();
        Map<TupleTag<?>, PValue> outputs = context.getOutputs();
        Map<TupleTag<?>, Coder<?>> outputCoders = context.getOutputCoders();
        DoFnSignature signature = DoFnSignatures.getSignature(transform.getFn().getClass());
        boolean stateful = signature.stateDeclarations().size() > 0 || signature.timerDeclarations().size() > 0;
        DoFnSchemaInformation doFnSchemaInformation = ParDoTranslation.getSchemaInformation(context.getCurrentTransform());
        TupleTag mainOutput = transform.getMainOutputTag();
        ArrayList additionalOutputTags = new ArrayList(outputs.size() - 1);
        List sideInputs = transform.getSideInputs();
        try {
            mainOutputTag = ParDoTranslation.getMainOutputTag(context.getCurrentTransform());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        HashMap outputMap = Maps.newHashMap();
        outputMap.put(mainOutputTag, 0);
        int count = 1;
        for (TupleTag<?> tag : outputs.keySet()) {
            if (outputMap.containsKey(tag)) continue;
            outputMap.put(tag, count++);
        }
        ComputeTSet outputTSet = inputTTSet.direct().compute(new DoFnFunction(context.getOptions(), doFn, inputCoder, outputCoders, additionalOutputTags, windowingStrategy, sideInputs, mainOutput, doFnSchemaInformation, outputMap));
        for (Map.Entry<TupleTag<?>, PValue> output : outputs.entrySet()) {
            ComputeTSet tempTSet = outputTSet.direct().compute(new OutputTagFilter((Integer)outputMap.get(output.getKey())));
            context.setOutputDataSet((PCollection)output.getValue(), tempTSet);
        }
    }
}

