/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.twister2.translators.functions;

import edu.iu.dsc.tws.api.comms.structs.Tuple;
import edu.iu.dsc.tws.api.tset.TSetContext;
import edu.iu.dsc.tws.api.tset.fn.MapFunc;
import java.util.Iterator;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.beam.runners.twister2.utils.TranslationUtils;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.KV;

public class ByteToWindowFunction<K, V>
implements MapFunc<KV<K, Iterable<WindowedValue<V>>>, Tuple<byte[], Iterator<byte[]>>> {
    private final Coder<K> keyCoder;
    private final WindowedValue.WindowedValueCoder<V> wvCoder;

    public ByteToWindowFunction(Coder<K> inputKeyCoder, WindowedValue.WindowedValueCoder<V> wvCoder) {
        this.keyCoder = inputKeyCoder;
        this.wvCoder = wvCoder;
    }

    public KV<K, Iterable<WindowedValue<V>>> map(Tuple<byte[], Iterator<byte[]>> input) {
        K key = TranslationUtils.fromByteArray((byte[])input.getKey(), this.keyCoder);
        Iterable value = StreamSupport.stream(Spliterators.spliteratorUnknownSize((Iterator)input.getValue(), 16), false).map((? super T bytes) -> TranslationUtils.fromByteArray(bytes, this.wvCoder)).collect(Collectors.toList());
        return KV.of(key, (Object)value);
    }

    public void prepare(TSetContext context) {
    }
}

