/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.twister2.translators.functions;

import edu.iu.dsc.tws.api.tset.Collector;
import edu.iu.dsc.tws.api.tset.TSetContext;
import edu.iu.dsc.tws.api.tset.fn.ComputeCollectorFunc;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.beam.runners.core.DoFnRunner;
import org.apache.beam.runners.core.DoFnRunners;
import org.apache.beam.runners.core.InMemoryStateInternals;
import org.apache.beam.runners.core.SideInputHandler;
import org.apache.beam.runners.core.SideInputReader;
import org.apache.beam.runners.core.StateInternals;
import org.apache.beam.runners.core.StepContext;
import org.apache.beam.runners.twister2.utils.NoOpStepContext;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.DoFnSchemaInformation;
import org.apache.beam.sdk.transforms.join.RawUnionValue;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.WindowingStrategy;

public class DoFnFunction<OT, IT>
implements ComputeCollectorFunc<RawUnionValue, Iterator<WindowedValue<IT>>> {
    private final DoFn<IT, OT> doFn;
    private final transient PipelineOptions pipelineOptions;
    private static final long serialVersionUID = -5701440128544343353L;
    private final Coder<IT> inputCoder;
    private final Map<TupleTag<?>, Coder<?>> outputCoders;
    private final WindowingStrategy<?, ?> windowingStrategy;
    private final Collection<PCollectionView<?>> sideInputs;
    private final TupleTag<OT> mainOutput;
    private transient SideInputHandler sideInputReader;
    private transient DoFnRunner<IT, OT> doFnRunner;
    private final DoFnOutputManager outputManager;
    private final List<TupleTag<?>> sideOutputs;
    private StepContext stepcontext;
    private final DoFnSchemaInformation doFnSchemaInformation;
    private final Map<TupleTag<?>, Integer> outputMap;

    public DoFnFunction(PipelineOptions pipelineOptions, DoFn<IT, OT> doFn, Coder<IT> inputCoder, Map<TupleTag<?>, Coder<?>> outputCoders, List<TupleTag<?>> sideOutputs, WindowingStrategy<?, ?> windowingStrategy, Collection<PCollectionView<?>> sideInputs, TupleTag<OT> mainOutput, DoFnSchemaInformation doFnSchemaInformation, Map<TupleTag<?>, Integer> outputMap) {
        this.doFn = doFn;
        this.pipelineOptions = pipelineOptions;
        this.inputCoder = inputCoder;
        this.outputCoders = outputCoders;
        this.windowingStrategy = windowingStrategy;
        this.sideInputs = sideInputs;
        this.mainOutput = mainOutput;
        this.doFnSchemaInformation = doFnSchemaInformation;
        this.sideOutputs = sideOutputs;
        this.stepcontext = new NoOpStepContext();
        this.outputMap = outputMap;
        this.outputManager = new DoFnOutputManager(this.outputMap);
    }

    public void prepare(TSetContext context) {
        this.sideInputReader = new SideInputHandler(this.sideInputs, (StateInternals)InMemoryStateInternals.forKey(null));
        this.outputManager.setup(this.mainOutput, this.sideOutputs);
        this.doFnRunner = DoFnRunners.simpleRunner((PipelineOptions)this.pipelineOptions, this.doFn, (SideInputReader)this.sideInputReader, (DoFnRunners.OutputManager)this.outputManager, this.mainOutput, this.sideOutputs, (StepContext)this.stepcontext, this.inputCoder, this.outputCoders, this.windowingStrategy, (DoFnSchemaInformation)this.doFnSchemaInformation);
    }

    public void compute(Iterator<WindowedValue<IT>> input, Collector<RawUnionValue> output) {
        this.outputManager.clear();
        this.doFnRunner.startBundle();
        while (input.hasNext()) {
            this.doFnRunner.processElement(input.next());
        }
        this.doFnRunner.finishBundle();
        Iterator<RawUnionValue> outputs = this.outputManager.getOutputs();
        while (outputs.hasNext()) {
            output.collect((Object)outputs.next());
        }
    }

    private static class DoFnOutputManager
    implements DoFnRunners.OutputManager,
    Serializable {
        private static final long serialVersionUID = 4967375172737408160L;
        private transient List<RawUnionValue> outputs;
        private transient Set<TupleTag<?>> outputTags;
        private final Map<TupleTag<?>, Integer> outputMap;

        DoFnOutputManager(Map<TupleTag<?>, Integer> outputMap) {
            this.outputMap = outputMap;
        }

        public <T> void output(TupleTag<T> outputTag, WindowedValue<T> output) {
            if (this.outputTags.contains(outputTag)) {
                this.outputs.add(new RawUnionValue(this.outputMap.get(outputTag).intValue(), output));
            }
        }

        void setup(TupleTag<?> mainOutput, List<TupleTag<?>> sideOutputs) {
            this.outputs = new ArrayList<RawUnionValue>();
            this.outputTags = new HashSet();
            this.outputTags.add(mainOutput);
            this.outputTags.addAll(sideOutputs);
        }

        void clear() {
            this.outputs.clear();
        }

        Iterator<RawUnionValue> getOutputs() {
            return this.outputs.iterator();
        }
    }
}

