/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.twister2.utils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.util.WindowedValue;

public final class TranslationUtils {
    private TranslationUtils() {
    }

    public static <T> T fromByteArray(byte[] serialized, Coder<T> coder) {
        ByteArrayInputStream bais = new ByteArrayInputStream(serialized);
        try {
            return (T)coder.decode((InputStream)bais);
        }
        catch (IOException e) {
            throw new IllegalStateException("Error decoding bytes for coder: " + coder, e);
        }
    }

    public static <T> WindowedValue<T> fromByteArray(byte[] serialized, WindowedValue.WindowedValueCoder<T> coder) {
        ByteArrayInputStream bais = new ByteArrayInputStream(serialized);
        try {
            return (WindowedValue)coder.decode((InputStream)bais);
        }
        catch (IOException e) {
            throw new IllegalStateException("Error decoding bytes for coder: " + coder, e);
        }
    }
}

